/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.webClient;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.giovannilamarmora.utils.logger.LoggerFilter;
import io.github.giovannilamarmora.utils.utilities.Mapper;
import io.github.giovannilamarmora.utils.web.WebManager;
import io.github.giovannilamarmora.utils.webClient.WebClientException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.stereotype.Component;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilder;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpResponseDecoderSpec;

@Component
public class WebClientRest {
    private static final String END_STRING = "\n";
    private WebClient webClient;
    private final Logger LOG = LoggerFilter.getLogger(this.getClass());
    private String baseUrl;

    public void init(WebClient.Builder builder) {
        this.LOG.info("Initializing WebClient with:");
        if (this.baseUrl != null) {
            builder.baseUrl(this.baseUrl);
            this.LOG.info("BaseUrl: {}", (Object)this.baseUrl);
        }
        HttpClient httpClient = HttpClient.create().httpResponseDecoder(spec -> (HttpResponseDecoderSpec)spec.maxHeaderSize(32768));
        this.webClient = builder.exchangeStrategies(ExchangeStrategies.builder().codecs(this::acceptedCodecs).build()).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
    }

    public <T> Mono<ResponseEntity<T>> perform(HttpMethod method, Function<UriBuilder, URI> uri, HttpHeaders headers, Class<T> returnType) {
        return this.perform(method, uri, null, headers, returnType);
    }

    public <T> Mono<ResponseEntity<List<T>>> performList(HttpMethod method, Function<UriBuilder, URI> uri, HttpHeaders headers, Class<T> returnType) {
        return this.performList(method, uri, null, headers, returnType);
    }

    public <T> Mono<ResponseEntity<T>> perform(HttpMethod method, Function<UriBuilder, URI> url, Object body, HttpHeaders headers, Class<T> returnType) {
        StringBuilder logBuilder = new StringBuilder("Performing (").append(method).append(") call with WebClient to the EndPoint: ").append(WebManager.getUrlAsString(url, this.baseUrl)).append(END_STRING);
        WebClient.RequestHeadersSpec<?> buildCall = this.buildCall(url, headers, method, body, logBuilder);
        return buildCall.retrieve().onStatus(HttpStatusCode::isError, clientResponse -> this.handleException((ClientResponse)clientResponse, WebManager.getUrlAsString(url, this.baseUrl), headers)).toEntity(returnType).doFirst(() -> this.LOG.info(logBuilder.toString())).map(r -> this.mapResponseEntity((ResponseEntity)r, WebManager.getUrlAsString(url, this.baseUrl)));
    }

    public <T> Mono<ResponseEntity<List<T>>> performList(HttpMethod method, Function<UriBuilder, URI> url, Object body, HttpHeaders headers, Class<T> returnType) {
        StringBuilder logBuilder = new StringBuilder("Performing (").append(method).append(") call with WebClient to the EndPoint: ").append(WebManager.getUrlAsString(url, this.baseUrl)).append(url.toString()).append(END_STRING);
        WebClient.RequestHeadersSpec<?> buildCall = this.buildCall(url, headers, method, body, logBuilder);
        return buildCall.retrieve().onStatus(HttpStatusCode::isError, clientResponse -> this.handleException((ClientResponse)clientResponse, WebManager.getUrlAsString(url, this.baseUrl), headers)).toEntityList(returnType).doFirst(() -> this.LOG.info(logBuilder.toString())).doOnSuccess(r -> this.mapResponseEntity((ResponseEntity)r, WebManager.getUrlAsString(url, this.baseUrl)));
    }

    private WebClient.RequestHeadersSpec<?> buildCall(Function<UriBuilder, URI> url, HttpHeaders headers, HttpMethod method, Object body, StringBuilder logBuilder) throws WebClientException {
        if (body != null) {
            logBuilder.append("Body: ").append(END_STRING).append(Mapper.writeObjectToString(body)).append(END_STRING).append(END_STRING);
            return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.method(method).uri(url)).headers(this.getDefaultHttpHeaders(headers, logBuilder))).body(BodyInserters.fromValue((Object)body));
        }
        return ((WebClient.RequestBodySpec)this.webClient.method(method).uri(url)).headers(this.getDefaultHttpHeaders(headers, logBuilder));
    }

    private Consumer<HttpHeaders> getDefaultHttpHeaders(HttpHeaders headerList, StringBuilder logBuilder) {
        logBuilder.append("Headers:").append(END_STRING);
        headerList.forEach((name, values) -> values.forEach(value -> logBuilder.append((String)name).append(":").append((String)value).append(END_STRING)));
        return headers -> headers.putAll((Map)headerList);
    }

    private <T> void logReturnSome(HttpStatusCode code, String uri, HttpHeaders headers, String jsonBody) {
        StringBuilder header = new StringBuilder();
        headers.forEach((name, values) -> values.forEach(value -> header.append((String)name).append(": ").append((String)value).append(END_STRING)));
        if (!code.isError()) {
            this.LOG.info("Received Response with Status code: {} from: {} \n\nHeaders:\n{}\n\nBody:\n{}\n", new Object[]{code, uri, header, jsonBody});
        } else {
            this.LOG.error("Received Response with Status code: {} from: {} \n\nHeaders:\n{}\n\nBody:\n{}\n", new Object[]{code, uri, header, jsonBody});
        }
    }

    private <T> ResponseEntity<T> mapResponseEntity(ResponseEntity<T> x, String uri) {
        this.logReturnSome(x.getStatusCode(), uri, x.getHeaders(), Mapper.writeObjectToString(x.getBody()));
        return x;
    }

    private Mono<? extends Throwable> handleException(ClientResponse response, String uri, HttpHeaders headers) {
        List getHeaders = headers.get((Object)"Content-Type");
        if (getHeaders != null && !getHeaders.isEmpty() && (getHeaders.contains("text/xml") || getHeaders.contains("text/plain") || getHeaders.contains("application/x-www-form-urlencoded"))) {
            return response.toEntity(String.class).flatMap(w -> this.flatMapResponse((ResponseEntity<?>)w, uri));
        }
        return response.toEntity(Object.class).flatMap(w -> this.flatMapResponse((ResponseEntity<?>)w, uri));
    }

    private <R> Mono<R> flatMapResponse(ResponseEntity<?> w, String uri) {
        this.logReturnSome(w.getStatusCode(), uri, w.getHeaders(), Mapper.writeObjectToString(w.getBody()));
        String message = "An error happened while calling the API: " + (this.baseUrl != null ? this.baseUrl : "") + uri + ", Status Code: " + String.valueOf(w.getStatusCode()) + ", and body message " + Mapper.writeObjectToString(w.getBody());
        throw new WebClientException(message, Mapper.writeObjectToString(w.getBody()));
    }

    private void acceptedCodecs(ClientCodecConfigurer clientCodecConfigurer) {
        clientCodecConfigurer.customCodecs().register((Object)new Jackson2JsonEncoder(new ObjectMapper(), new MimeType[]{MediaType.TEXT_HTML}));
        clientCodecConfigurer.customCodecs().register((Object)new Jackson2JsonDecoder(new ObjectMapper(), new MimeType[]{MediaType.TEXT_HTML}));
        clientCodecConfigurer.customCodecs().register((Object)new Jackson2JsonEncoder(new ObjectMapper(), new MimeType[]{MediaType.TEXT_PLAIN}));
        clientCodecConfigurer.customCodecs().register((Object)new Jackson2JsonDecoder(new ObjectMapper(), new MimeType[]{MediaType.TEXT_PLAIN}));
    }

    @Generated
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

