/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.generic;

import com.fasterxml.jackson.annotation.JsonInclude;
import jakarta.persistence.Column;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@MappedSuperclass
public abstract class GenericEntity {
    @Column(name="CREATION_DATE", updatable=false)
    private LocalDateTime creationDate;
    @Column(name="UPDATE_DATE")
    private LocalDateTime updateDate;
    @Column(name="DELETED_DATE")
    private LocalDateTime deletedDate;

    @PrePersist
    public void creationDates() {
        LocalDateTime now = LocalDateTime.now().truncatedTo(ChronoUnit.SECONDS);
        this.setCreationDate(now);
        this.setUpdateDate(now);
    }

    @PreUpdate
    public void updateDates() {
        this.setUpdateDate(LocalDateTime.now().truncatedTo(ChronoUnit.SECONDS));
    }

    public LocalDateTime getCreationDate() {
        return this.creationDate;
    }

    public LocalDateTime getUpdateDate() {
        return this.updateDate;
    }

    public LocalDateTime getDeletedDate() {
        return this.deletedDate;
    }

    public void setCreationDate(LocalDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public void setUpdateDate(LocalDateTime updateDate) {
        this.updateDate = updateDate;
    }

    public void setDeletedDate(LocalDateTime deletedDate) {
        this.deletedDate = deletedDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericEntity)) {
            return false;
        }
        GenericEntity other = (GenericEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocalDateTime this$creationDate = this.getCreationDate();
        LocalDateTime other$creationDate = other.getCreationDate();
        if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
            return false;
        }
        LocalDateTime this$updateDate = this.getUpdateDate();
        LocalDateTime other$updateDate = other.getUpdateDate();
        if (this$updateDate == null ? other$updateDate != null : !((Object)this$updateDate).equals(other$updateDate)) {
            return false;
        }
        LocalDateTime this$deletedDate = this.getDeletedDate();
        LocalDateTime other$deletedDate = other.getDeletedDate();
        return !(this$deletedDate == null ? other$deletedDate != null : !((Object)this$deletedDate).equals(other$deletedDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenericEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDateTime $creationDate = this.getCreationDate();
        result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
        LocalDateTime $updateDate = this.getUpdateDate();
        result = result * 59 + ($updateDate == null ? 43 : ((Object)$updateDate).hashCode());
        LocalDateTime $deletedDate = this.getDeletedDate();
        result = result * 59 + ($deletedDate == null ? 43 : ((Object)$deletedDate).hashCode());
        return result;
    }

    public String toString() {
        return "GenericEntity(creationDate=" + String.valueOf(this.getCreationDate()) + ", updateDate=" + String.valueOf(this.getUpdateDate()) + ", deletedDate=" + String.valueOf(this.getDeletedDate()) + ")";
    }

    public GenericEntity() {
    }

    public GenericEntity(LocalDateTime creationDate, LocalDateTime updateDate, LocalDateTime deletedDate) {
        this.creationDate = creationDate;
        this.updateDate = updateDate;
        this.deletedDate = deletedDate;
    }
}

