/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.config;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.Payload;
import com.google.cloud.logging.Severity;
import com.google.cloud.logging.logback.LoggingEventEnhancer;
import io.github.giovannilamarmora.utils.interceptors.correlationID.CorrelationIdUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class GoogleLogConfig
implements LoggingEventEnhancer {
    public void enhanceLogEntry(LogEntry.Builder logEntry, ILoggingEvent e) {
        InputStream inputStream = GoogleLogConfig.class.getClassLoader().getResourceAsStream("application.yml");
        Yaml yaml = new Yaml();
        Map yamlProperties = (Map)yaml.load(inputStream);
        String env = String.valueOf(yamlProperties.get("env"));
        logEntry.setSeverity(this.mapSeverity(e.getLevel()));
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!env.equalsIgnoreCase("Local") && !env.equalsIgnoreCase("Default")) {
            map.put("env", env);
        }
        map.put("thread", e.getThreadName());
        map.put("context", e.getLoggerContextVO().getName());
        map.put("logger", e.getLoggerName());
        map.put("mdc", e.getMDCPropertyMap());
        Payload.JsonPayload payload = (Payload.JsonPayload)logEntry.build().getPayload();
        map.putAll(payload.getDataAsMap());
        logEntry.setPayload((Payload)Payload.JsonPayload.of(map));
        logEntry.setTrace(CorrelationIdUtils.getCorrelationId());
    }

    private Severity mapSeverity(Level level) {
        switch (level.toInt()) {
            case 40000: {
                return Severity.ERROR;
            }
            case 30000: {
                return Severity.WARNING;
            }
            case 20000: {
                return Severity.INFO;
            }
            case 5000: 
            case 10000: {
                return Severity.DEBUG;
            }
        }
        return Severity.DEFAULT;
    }
}

