/*
 * Decompiled with CFR 0.152.
 */
package api.log.base;

public class R<T> {
    private static final int SUCCESS = 200;
    private static final int FAILURE = 1000;
    private Integer code;
    private T data;
    private String message;

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static <T> R<T> ok() {
        R<T> r = new R<T>();
        r.setCode(200);
        r.setMessage("Success!");
        return r;
    }

    public static <T> R<T> ok(T data) {
        return R.success(200, data, "Success");
    }

    public static <T> R<T> ok(T data, String msg) {
        return R.success(200, data, msg);
    }

    public static <T> R<T> success(Integer code, T data, String msg) {
        R<T> r = new R<T>();
        r.setCode(code);
        r.setData(data);
        r.setMessage(msg);
        return r;
    }

    public static <T> R<T> failure() {
        R<T> r = new R<T>();
        r.setCode(1000);
        r.setMessage("Failure!");
        return r;
    }

    public static <T> R<T> failure(String msg) {
        R<T> r = new R<T>();
        r.setCode(1000);
        r.setMessage(msg);
        return r;
    }

    public static <T> R<T> failure(Integer code, String msg) {
        R<T> r = new R<T>();
        r.setCode(code);
        r.setMessage(msg);
        return r;
    }

    public static <T> R<T> failure(Integer code, T object, String msg) {
        R<T> r = new R<T>();
        r.setCode(code);
        r.setData(object);
        r.setMessage(msg);
        return r;
    }
}

