/*
 * Decompiled with CFR 0.152.
 */
package api.log.cmd;

import api.log.base.MonitorInfo;
import api.log.cache.Cache;
import api.log.cmd.CommonCmd;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class Monitor
extends CommonCmd {
    public Monitor(String args) {
        super(args);
    }

    @Override
    public String check(String[] args) {
        if (args.length != 1 && args.length != 2) {
            return "\u53c2\u6570\u9519\u8bef,\u683c\u5f0f\u4e3a\uff1amonitor [\u63a5\u53e3\u8def\u5f84] [param|result|time]";
        }
        if (!Cache.hasUri(args[0])) {
            return "\u53c2\u6570\u9519\u8bef,\u63a5\u53e3\u8def\u5f84\u4e0d\u5b58\u5728";
        }
        if (args.length == 2) {
            List<String> apiContents = Arrays.asList("param", "result", "time");
            boolean include = Arrays.stream(args[1].split(",")).anyMatch(s -> apiContents.contains(s.trim()));
            if (!include) {
                return "\u53c2\u6570\u9519\u8bef,\u53ef\u9009\u503c [param|result|time]";
            }
        }
        return "";
    }

    @Override
    public String execute(String user, String cmd, String[] args) {
        Method method = Cache.getMethod(args[0].trim());
        if (args.length == 1) {
            Cache.addMethod(user, new MonitorInfo(method, true, true, true));
        } else if (args.length == 2) {
            String trimCmd = args[1].trim();
            boolean param = false;
            boolean result = false;
            boolean time = false;
            if (trimCmd.contains("param")) {
                param = true;
            }
            if (trimCmd.contains("result")) {
                result = true;
            }
            if (trimCmd.contains("time")) {
                time = true;
            }
            Cache.addMethod(user, new MonitorInfo(method, param, result, time));
        }
        return "success";
    }
}

