/*
 * Decompiled with CFR 0.152.
 */
package api.log.config;

import api.log.aop.MethodAdvice;
import api.log.aop.MethodPointcut;
import api.log.base.ContextUtil;
import api.log.formater.DefaultParamFormatter;
import api.log.outer.WebSocketOuter;
import api.log.socket.SocketHandler;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

@EnableWebSocket
@Configuration
@EnableAspectJAutoProxy
public class ALogConfig
implements ImportBeanDefinitionRegistrar,
WebSocketConfigurer {
    @Bean
    public MethodPointcut pointcut() {
        return new MethodPointcut();
    }

    @Bean
    public MethodAdvice advice() {
        return new MethodAdvice();
    }

    @Bean
    public DefaultPointcutAdvisor defaultPointcutAdvisor() {
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor((Pointcut)this.pointcut(), (Advice)this.advice());
        advisor.setOrder(Integer.MAX_VALUE);
        return advisor;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        this.registerBean(registry);
        this.scanPackages(registry, "api.log");
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        registry.addHandler((WebSocketHandler)ContextUtil.getBean(SocketHandler.class), new String[]{"/alog-ws"}).setAllowedOrigins(new String[]{"*"});
    }

    private void registerBean(BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder defaultParamFormatterBuilder = BeanDefinitionBuilder.rootBeanDefinition(DefaultParamFormatter.class).setScope("singleton");
        if (!registry.containsBeanDefinition("defaultParamFormatter")) {
            registry.registerBeanDefinition("defaultParamFormatter", (BeanDefinition)defaultParamFormatterBuilder.getBeanDefinition());
        }
        BeanDefinitionBuilder defaultOuterBuilder = BeanDefinitionBuilder.rootBeanDefinition(WebSocketOuter.class).setScope("singleton");
        if (!registry.containsBeanDefinition("webSocketOuter")) {
            registry.registerBeanDefinition("webSocketOuter", (BeanDefinition)defaultOuterBuilder.getBeanDefinition());
        }
    }

    private void scanPackages(BeanDefinitionRegistry registry, String ... basePackages) {
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(registry);
        scanner.scan(basePackages);
    }
}

