/*
 * Decompiled with CFR 0.152.
 */
package api.log.formater;

import api.log.formater.ParamFormatter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultParamFormatter
implements ParamFormatter {
    @Override
    public Object format(Parameter[] parameters, Object[] parameterValues) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parameters.length; ++i) {
            String formatValues = this.formatValue(parameterValues[i]);
            sb.append("\"").append(parameters[i].getName()).append("\"").append(":").append(formatValues).append(" ");
        }
        return sb.toString();
    }

    private String formatValue(Object value) {
        if (value == null) {
            return "null";
        }
        Class<?> clazz = value.getClass();
        if (this.isPrimitiveOrWrapper(clazz)) {
            if (value instanceof String && "".equals(value.toString().trim())) {
                return "\"\"";
            }
            return value.toString();
        }
        if (clazz.isArray()) {
            return this.formatArray(value);
        }
        if (value instanceof Collection) {
            return this.formatCollection((Collection)value);
        }
        if (value instanceof Map) {
            return this.formatMap((Map)value);
        }
        return this.formatObject(value);
    }

    private boolean isPrimitiveOrWrapper(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == Integer.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Boolean.class || clazz == Character.class || clazz == Byte.class || clazz == Short.class || clazz == String.class;
    }

    private String formatArray(Object array) {
        StringBuilder sb = new StringBuilder("[");
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            sb.append(this.formatValue(Array.get(array, i)));
            if (i >= length - 1) continue;
            sb.append(", ");
        }
        return sb.append("]").toString();
    }

    private String formatCollection(Collection<?> collection) {
        StringBuilder sb = new StringBuilder("[");
        Iterator<?> it = collection.iterator();
        while (it.hasNext()) {
            sb.append(this.formatValue(it.next()));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.append("]").toString();
    }

    private String formatMap(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Iterator<Map.Entry<?, ?>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<?, ?> entry = it.next();
            sb.append(this.formatValue(entry.getKey())).append("=").append(this.formatValue(entry.getValue()));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.append("}").toString();
    }

    private String formatObject(Object obj) {
        try {
            StringBuilder sb = new StringBuilder("{");
            List<Field> fields = this.getAllFields(obj.getClass());
            for (int i = 0; i < fields.size(); ++i) {
                Field field = fields.get(i);
                field.setAccessible(true);
                sb.append("\"").append(field.getName()).append("\"").append(":").append(this.formatValue(field.get(obj)));
                if (i >= fields.size() - 1) continue;
                sb.append(", ");
            }
            return sb.append("}").toString();
        }
        catch (IllegalAccessException e) {
            return "[Error accessing fields]";
        }
    }

    private List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null && clazz != Object.class) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }
}

