/*
 * Decompiled with CFR 0.152.
 */
package api.log.socket;

import api.log.cmd.ClearAll;
import api.log.cmd.Ls;
import api.log.cmd.Monitor;
import api.log.cmd.Remove;
import api.log.socket.SessionContext;
import api.log.socket.SessionManager;
import java.io.IOException;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component(value="alogSocketHandler")
public class SocketHandler
extends TextWebSocketHandler {
    @Qualifier(value="alogSessionManager")
    @Autowired
    private SessionManager sessionManager;

    public void afterConnectionEstablished(WebSocketSession session) {
        SessionContext context = new SessionContext(session);
        this.sessionManager.addSession(session.getId(), context);
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        this.sessionManager.removeSession(session.getId());
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        String cmd = (String)message.getPayload();
        try {
            this.executeCommand(cmd, this.sessionManager.getSession(session.getId()));
        }
        catch (Exception e) {
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)("Error: " + e.getMessage() + "\n")));
        }
    }

    private void executeCommand(String cmd, SessionContext context) throws IOException {
        WebSocketSession session = context.getSession();
        String userId = context.getUserId();
        if (Objects.isNull(cmd) || cmd.isEmpty()) {
            this.sendToClient(session, "\u8bf7\u8f93\u5165\u547d\u4ee4");
        } else {
            String trimCmd = cmd.trim();
            Object result = "";
            if (trimCmd.startsWith("ls")) {
                Ls ls = new Ls(trimCmd);
                result = ls.exec(userId);
                this.sendToClient(session, result.toString().replace("@@", "\n"));
            } else if (trimCmd.startsWith("monitor")) {
                result = new Monitor(trimCmd).exec(userId);
                this.sendToClient(session, result.toString());
            } else if (trimCmd.startsWith("remove")) {
                result = new Remove(trimCmd).exec(userId);
                this.sendToClient(session, result.toString());
            } else if (trimCmd.startsWith("clearall")) {
                result = new ClearAll(trimCmd).exec(userId);
                this.sendToClient(session, result.toString());
            } else {
                result = "\u547d\u4ee4\u4e0d\u652f\u6301";
                this.sendToClient(session, result.toString());
            }
        }
    }

    public void sendToClient(WebSocketSession session, String message) {
        try {
            if (session.isOpen()) {
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)(message + "\n")));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

