/*
 * Decompiled with CFR 0.152.
 */
package io.github.givimad.rustpotter_java;

import io.github.givimad.rustpotter_java.InternalPointerMarker;
import io.github.givimad.rustpotter_java.NativeUtils;
import io.github.givimad.rustpotter_java.RustpotterDetection;
import java.io.IOException;
import java.util.Optional;

public final class RustpotterJava {
    long mNativeObj;

    private RustpotterJava() {
    }

    public final Optional<RustpotterDetection> process(int[] buffer) {
        long ret = RustpotterJava.do_process(this.mNativeObj, buffer);
        Optional<RustpotterDetection> convRet = ret != 0L ? Optional.of(new RustpotterDetection(InternalPointerMarker.RAW_PTR, ret)) : Optional.empty();
        return convRet;
    }

    private static native long do_process(long var0, int[] var2);

    public final Optional<RustpotterDetection> processInt(int[] buffer) {
        long ret = RustpotterJava.do_processInt(this.mNativeObj, buffer);
        Optional<RustpotterDetection> convRet = ret != 0L ? Optional.of(new RustpotterDetection(InternalPointerMarker.RAW_PTR, ret)) : Optional.empty();
        return convRet;
    }

    private static native long do_processInt(long var0, int[] var2);

    public final Optional<RustpotterDetection> processSort(short[] buffer) {
        long ret = RustpotterJava.do_processSort(this.mNativeObj, buffer);
        Optional<RustpotterDetection> convRet = ret != 0L ? Optional.of(new RustpotterDetection(InternalPointerMarker.RAW_PTR, ret)) : Optional.empty();
        return convRet;
    }

    private static native long do_processSort(long var0, short[] var2);

    public final Optional<RustpotterDetection> processByte(byte[] buffer) {
        long ret = RustpotterJava.do_processByte(this.mNativeObj, buffer);
        Optional<RustpotterDetection> convRet = ret != 0L ? Optional.of(new RustpotterDetection(InternalPointerMarker.RAW_PTR, ret)) : Optional.empty();
        return convRet;
    }

    private static native long do_processByte(long var0, byte[] var2);

    public final Optional<RustpotterDetection> processFloat(float[] buffer) {
        long ret = RustpotterJava.do_processFloat(this.mNativeObj, buffer);
        Optional<RustpotterDetection> convRet = ret != 0L ? Optional.of(new RustpotterDetection(InternalPointerMarker.RAW_PTR, ret)) : Optional.empty();
        return convRet;
    }

    private static native long do_processFloat(long var0, float[] var2);

    public final void addWakewordModelFile(String path) {
        RustpotterJava.do_addWakewordModelFile(this.mNativeObj, path);
    }

    private static native void do_addWakewordModelFile(long var0, String var2);

    public final long getFrameSize() {
        long ret = RustpotterJava.do_getFrameSize(this.mNativeObj);
        return ret;
    }

    private static native long do_getFrameSize(long var0);

    public synchronized void delete() {
        if (this.mNativeObj != 0L) {
            RustpotterJava.do_delete(this.mNativeObj);
            this.mNativeObj = 0L;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    private static native void do_delete(long var0);

    RustpotterJava(InternalPointerMarker marker, long ptr) {
        assert (marker == InternalPointerMarker.RAW_PTR);
        this.mNativeObj = ptr;
    }

    public static void loadLibrary() {
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            String osArch = System.getProperty("os.arch").toLowerCase();
            if (osName.contains("win")) {
                if (osArch.contains("amd64") || osArch.contains("x86_64")) {
                    NativeUtils.loadLibraryFromJar("/librustpotter_java_win_x86_64.dll");
                    return;
                }
            } else if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
                if (osArch.contains("amd64") || osArch.contains("x86_64")) {
                    NativeUtils.loadLibraryFromJar("/librustpotter_java_debian_x86_64.so");
                    return;
                }
                if (osArch.contains("aarch64") || osArch.contains("arm64")) {
                    NativeUtils.loadLibraryFromJar("/librustpotter_java_debian_aarch64.so");
                    return;
                }
                if (osArch.contains("armv7") || osArch.contains("arm")) {
                    NativeUtils.loadLibraryFromJar("/librustpotter_java_debian_armv7l.so");
                    return;
                }
            } else if (osName.contains("mac") || osName.contains("darwin")) {
                if (osArch.contains("amd64") || osArch.contains("x86_64")) {
                    NativeUtils.loadLibraryFromJar("/librustpotter_java_macos_x86_64.dylib");
                    return;
                }
                if (osArch.contains("aarch64") || osArch.contains("arm64")) {
                    NativeUtils.loadLibraryFromJar("/librustpotter_java_macos_aarch64.dylib");
                    return;
                }
            }
            throw new IOException("Rustpotter: Unsupported platform.");
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }
}

