/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.typeResolvers;

import graphql.TypeResolutionEnvironment;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import graphql.schema.TypeResolver;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class UnionTypeResolver
implements TypeResolver {
    private final Map<Class<?>, GraphQLType> types = new HashMap();

    public UnionTypeResolver(Class<?>[] classes, ProcessingElementsContainer container) {
        Arrays.stream(classes).forEach(c -> this.types.put((Class<?>)c, container.getDefaultTypeFunction().buildType((Class<?>)c, null, container)));
    }

    public GraphQLObjectType getType(TypeResolutionEnvironment env) {
        Object object = env.getObject();
        Optional<Map.Entry> maybeType = this.types.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(object.getClass())).findFirst();
        if (maybeType.isPresent()) {
            return (GraphQLObjectType)maybeType.get().getValue();
        }
        throw new RuntimeException("Unknown type " + object.getClass());
    }
}

