/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.retrievers.fieldBuilders.field;

import graphql.Scalars;
import graphql.annotations.annotationTypes.GraphQLDataFetcher;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import graphql.annotations.connection.GraphQLConnection;
import graphql.annotations.dataFetchers.ExtensionDataFetcherWrapper;
import graphql.annotations.dataFetchers.MethodDataFetcher;
import graphql.annotations.dataFetchers.connection.ConnectionDataFetcher;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.retrievers.fieldBuilders.Builder;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.annotations.processor.util.DataFetcherConstructor;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import graphql.schema.PropertyDataFetcher;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;

public class FieldDataFetcherBuilder
implements Builder<DataFetcher> {
    private Field field;
    private DataFetcherConstructor dataFetcherConstructor;
    private GraphQLType outputType;
    private TypeFunction typeFunction;
    private ProcessingElementsContainer container;
    private boolean isConnection;

    public FieldDataFetcherBuilder(Field field, DataFetcherConstructor dataFetcherConstructor, GraphQLType outputType, TypeFunction typeFunction, ProcessingElementsContainer container, boolean isConnection) {
        this.field = field;
        this.dataFetcherConstructor = dataFetcherConstructor;
        this.outputType = outputType;
        this.typeFunction = typeFunction;
        this.container = container;
        this.isConnection = isConnection;
    }

    @Override
    public DataFetcher build() {
        GraphQLDataFetcher dataFetcher = this.field.getAnnotation(GraphQLDataFetcher.class);
        ConnectionDataFetcher actualDataFetcher = null;
        if (Objects.nonNull(dataFetcher)) {
            actualDataFetcher = this.dataFetcherConstructor.constructDataFetcher(this.field.getName(), dataFetcher);
        }
        if (actualDataFetcher == null) {
            actualDataFetcher = this.handleNullCase(actualDataFetcher);
        }
        if (this.isConnection) {
            actualDataFetcher = new ConnectionDataFetcher(this.field.getAnnotation(GraphQLConnection.class).connection(), actualDataFetcher);
        }
        return actualDataFetcher;
    }

    private DataFetcher handleNullCase(DataFetcher actualDataFetcher) {
        actualDataFetcher = this.isaBoolean() ? this.getBooleanDataFetcher(actualDataFetcher) : (this.checkIfPrefixGetterExists(this.field.getDeclaringClass(), "get", this.field.getName()) ? this.wrapExtension((DataFetcher)new PropertyDataFetcher(this.field.getName()), this.field) : this.getDataFetcherWithFluentGetter(actualDataFetcher));
        if (actualDataFetcher == null) {
            actualDataFetcher = this.wrapExtension((DataFetcher)new PropertyDataFetcher(this.field.getName()), this.field);
        }
        return actualDataFetcher;
    }

    private DataFetcher getDataFetcherWithFluentGetter(DataFetcher actualDataFetcher) {
        StringBuilder fluentBuffer = new StringBuilder(this.field.getName());
        fluentBuffer.setCharAt(0, Character.toLowerCase(fluentBuffer.charAt(0)));
        String fluentGetter = fluentBuffer.toString();
        boolean hasFluentGetter = false;
        Method fluentMethod = null;
        try {
            fluentMethod = this.field.getDeclaringClass().getMethod(fluentGetter, new Class[0]);
            hasFluentGetter = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (hasFluentGetter) {
            actualDataFetcher = new MethodDataFetcher(fluentMethod, this.typeFunction, this.container);
        }
        return actualDataFetcher;
    }

    private DataFetcher wrapExtension(DataFetcher dataFetcher, Field field) {
        if (field.getDeclaringClass().isAnnotationPresent(GraphQLTypeExtension.class)) {
            return new ExtensionDataFetcherWrapper(field.getDeclaringClass(), dataFetcher);
        }
        return dataFetcher;
    }

    private DataFetcher getBooleanDataFetcher(DataFetcher actualDataFetcher) {
        if (this.checkIfPrefixGetterExists(this.field.getDeclaringClass(), "is", this.field.getName()) || this.checkIfPrefixGetterExists(this.field.getDeclaringClass(), "get", this.field.getName())) {
            actualDataFetcher = this.wrapExtension((DataFetcher)new PropertyDataFetcher(this.field.getName()), this.field);
        }
        return actualDataFetcher;
    }

    private boolean isaBoolean() {
        return this.outputType == Scalars.GraphQLBoolean || this.outputType instanceof GraphQLNonNull && ((GraphQLNonNull)this.outputType).getWrappedType() == Scalars.GraphQLBoolean;
    }

    private boolean checkIfPrefixGetterExists(Class c, String prefix, String propertyName) {
        String getterName = prefix + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            Method method = c.getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException x) {
            return false;
        }
        return true;
    }
}

