/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.directives;

import graphql.annotations.annotationTypes.directives.activation.GraphQLDirectives;
import graphql.annotations.directives.AnnotationsDirectiveWiring;
import graphql.annotations.processor.DirectiveAndWiring;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.annotations.processor.util.DirectiveJavaAnnotationUtil;
import graphql.schema.GraphQLDirective;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.stream.Stream;

public class DirectiveWiringMapRetriever {
    public HashMap<GraphQLDirective, AnnotationsDirectiveWiring> getDirectiveWiringMap(AnnotatedElement object, ProcessingElementsContainer container) {
        LinkedHashMap<GraphQLDirective, AnnotationsDirectiveWiring> map = new LinkedHashMap<GraphQLDirective, AnnotationsDirectiveWiring>();
        ((Stream)DirectiveJavaAnnotationUtil.getDirectiveAnnotations(object).sequential()).forEach(x -> this.putInMap(container, map, DirectiveJavaAnnotationUtil.getName(x)));
        GraphQLDirectives directivesContainer = object.getAnnotation(GraphQLDirectives.class);
        if (directivesContainer == null) {
            return map;
        }
        ((Stream)Arrays.stream(directivesContainer.value()).sequential()).forEach(x -> this.putInMap(container, map, x.name()));
        return map;
    }

    private void putInMap(ProcessingElementsContainer container, LinkedHashMap<GraphQLDirective, AnnotationsDirectiveWiring> map, String name) {
        if (!container.getDirectiveRegistry().containsKey(name)) {
            throw new GraphQLAnnotationsException(String.format("No directive named %s is found in the directive registry", name), null);
        }
        DirectiveAndWiring directiveAndWiring = container.getDirectiveRegistry().get(name);
        if (directiveAndWiring.getWiringClass() == null) {
            throw new GraphQLAnnotationsException("No wiring class was supplied to directive " + directiveAndWiring.getDirective().getName(), null);
        }
        try {
            map.put(directiveAndWiring.getDirective(), directiveAndWiring.getWiringClass().newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new GraphQLAnnotationsException("Cannot create an instance of the wiring class " + directiveAndWiring.getWiringClass().getSimpleName(), e);
        }
    }
}

