/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.payments.wxcodepay;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.http.UrlEncoder;
import com.wechat.pay.java.core.util.GsonUtil;
import com.wechat.pay.java.service.payments.jsapi.model.QueryOrderByIdRequest;
import com.wechat.pay.java.service.payments.jsapi.model.QueryOrderByOutTradeNoRequest;
import com.wechat.pay.java.service.payments.model.Transaction;
import com.wechat.pay.java.service.payments.wxcodepay.model.CloseOrderRequest;
import com.wechat.pay.java.service.payments.wxcodepay.model.PrepayRequest;
import com.wechat.pay.java.service.payments.wxcodepay.model.PrepayResponse;
import java.util.Objects;

public class CodePayService {
    private final HttpClient httpClient;
    private final HostName hostName;

    private CodePayService(HttpClient httpClient, HostName hostName) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.hostName = hostName;
    }

    public PrepayResponse prepay(PrepayRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/pay/transactions/codepay";
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(request)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, PrepayResponse.class);
        return (PrepayResponse)httpResponse.getServiceResponse();
    }

    public void closeOrder(CloseOrderRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/pay/transactions/out-trade-no/{out_trade_no}/reverse";
        requestPath = requestPath.replace("{out_trade_no}", UrlEncoder.urlEncode((String)request.getOutTradeNo()));
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(request)).build();
        this.httpClient.execute(httpRequest, (Class)null);
    }

    public Transaction queryOrderById(QueryOrderByIdRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/pay/transactions/id/{transaction_id}";
        requestPath = requestPath.replace("{transaction_id}", UrlEncoder.urlEncode((String)request.getTransactionId()));
        QueryParameter queryParameter = new QueryParameter();
        if (request.getMchid() != null) {
            queryParameter.add("mchid", (Object)UrlEncoder.urlEncode((String)request.getMchid()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, Transaction.class);
        return (Transaction)httpResponse.getServiceResponse();
    }

    public Transaction queryOrderByOutTradeNo(QueryOrderByOutTradeNoRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/pay/transactions/out-trade-no/{out_trade_no}";
        requestPath = requestPath.replace("{out_trade_no}", UrlEncoder.urlEncode((String)request.getOutTradeNo()));
        QueryParameter queryParameter = new QueryParameter();
        if (request.getMchid() != null) {
            queryParameter.add("mchid", (Object)UrlEncoder.urlEncode((String)request.getMchid()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, Transaction.class);
        return (Transaction)httpResponse.getServiceResponse();
    }

    private RequestBody createRequestBody(Object request) {
        return new JsonRequestBody.Builder().body(GsonUtil.toJson((Object)request)).build();
    }

    public static class Builder {
        private HttpClient httpClient;
        private HostName hostName;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().config(config).build();
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public CodePayService build() {
            return new CodePayService(this.httpClient, this.hostName);
        }
    }
}

