// Copyright 2021 Tencent Inc. All rights reserved.
//
// 商家转账对外API
//
// * 场景及业务流程：     商户可通过该产品实现同时向多个用户微信零钱进行转账的操作，可用于发放奖金补贴、佣金货款结算、员工报销等场景。
// [https://pay.weixin.qq.com/index.php/public/product/detail?pid=108&productType=0](https://pay.weixin.qq.com/index.php/public/product/detail?pid=108&productType=0) * 接入步骤：     * 商户在微信支付商户平台开通“批量转账到零钱”产品权限，并勾选“使用API方式发起转账”。     * 调用批量转账接口，对多个用户微信零钱发起转账。     * 调用查询批次接口，可获取到转账批次详情及当前状态。     * 调用查询明细接口，可获取到单条转账明细详情及当前状态。
//
// API version: 1.0.5

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.transferbills.model;

import com.google.gson.annotations.SerializedName;
import com.wechat.pay.java.core.cipher.Encryption;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

/**
 * InitiateBatchTransferRequest
 */
public class InitiateBillsTransferRequest {
    /**
     * 商户appid 说明：申请商户号的appid或商户号绑定的appid（企业号corpid即为此appid）
     */
    @SerializedName("appid")
    private String appid;

    /**
     * 商家批次单号 说明：商户系统内部的商家批次单号，要求此参数只能由数字、大小写字母组成，在商户系统内部唯一
     */
    @SerializedName("out_batch_no")
    private String outBatchNo;

    /**
     * 转账场景ID 说明：该批次转账使用的转账场景，如不填写则使用商家的默认场景，如无默认场景可为空，可前往“商家转账到零钱-前往功能”中申请。 如：1001-现金营销
     */
    @SerializedName("transfer_scene_id")
    private String transferSceneId;

    /**
     * 收款用户openid 说明：商户appid下，某用户的openid
     */
    @SerializedName("openid")
    private String openid;

    /**
     * 【收款用户姓名】 收款方真实姓名。需要加密传入，支持标准RSA算法和国密算法，公钥由微信侧提供。
     * 转账金额 >= 2,000元时，该笔明细必须填写
     * 若商户传入收款用户姓名，微信支付会校验收款用户与输入姓名是否一致，并提供电子回单
     */
    @SerializedName("user_name")
    private String userName;

    /**
     * 转账金额 说明：转账金额单位为“分”
     */
    @SerializedName("transfer_amount")
    private Long transferAmount;

    /**
     * 转账备注 说明：单条转账备注（微信用户会收到该备注），UTF8编码，最多允许32个字符
     */
    @SerializedName("transfer_remark")
    private String transferRemark;

    /**
     * 通知地址 说明：异步接收微信支付结果通知的回调地址，通知url必须为公网可访问的url，必须为https，不能携带参数。
     */
    @SerializedName("notify_url")
    private String notifyUrl;

    /**
     * 【用户收款感知】 用户收款时感知到的收款原因将根据转账场景自动展示默认内容。如有其他展示需求，
     * 可在本字段传入。各场景展示的默认内容和支持传入的内容，可查看 产品文档 了解。
     */
    @SerializedName("user_recv_perception")
    private String userRecvPerception;

    /**
     * 转账明细列表 说明：发起批量转账的明细列表，最多一千笔
     */
    @Encryption
    @SerializedName("transfer_scene_report_infos")
    private List<com.wechat.pay.java.service.transferbills.model.TransferSceneReportInfo> transferSceneReportInfo = new ArrayList<com.wechat.pay.java.service.transferbills.model.TransferSceneReportInfo>();

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getOutBatchNo() {
        return outBatchNo;
    }

    public void setOutBatchNo(String outBatchNo) {
        this.outBatchNo = outBatchNo;
    }

    public String getTransferSceneId() {
        return transferSceneId;
    }

    public void setTransferSceneId(String transferSceneId) {
        this.transferSceneId = transferSceneId;
    }

    public String getOpenid() {
        return openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Long getTransferAmount() {
        return transferAmount;
    }

    public void setTransferAmount(Long transferAmount) {
        this.transferAmount = transferAmount;
    }

    public String getTransferRemark() {
        return transferRemark;
    }

    public void setTransferRemark(String transferRemark) {
        this.transferRemark = transferRemark;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getUserRecvPerception() {
        return userRecvPerception;
    }

    public void setUserRecvPerception(String userRecvPerception) {
        this.userRecvPerception = userRecvPerception;
    }

    public List<TransferSceneReportInfo> getTransferSceneReportInfo() {
        return transferSceneReportInfo;
    }

    public void setTransferSceneReportInfo(List<TransferSceneReportInfo> transferSceneReportInfo) {
        this.transferSceneReportInfo = transferSceneReportInfo;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InitiateBillsTransferRequest {\n");
        sb.append("    appid: ").append(toIndentedString(appid)).append("\n");
        sb.append("    outBatchNo: ").append(toIndentedString(outBatchNo)).append("\n");
        sb.append("    transferSceneId: ").append(toIndentedString(transferSceneId)).append("\n");
        sb.append("    openid: ").append(toIndentedString(openid)).append("\n");
        sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
        sb.append("    transferAmount: ").append(toIndentedString(transferAmount)).append("\n");
        sb.append("    transferRemark: ").append(toIndentedString(transferRemark)).append("\n");
        sb.append("    notifyUrl: ").append(toIndentedString(notifyUrl)).append("\n");
        sb.append("    userRecvPerception: ").append(toIndentedString(userRecvPerception)).append("\n");
        sb.append("    transferSceneReportInfo: ").append(toIndentedString(transferSceneReportInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public InitiateBillsTransferRequest cloneWithCipher(UnaryOperator<String> s) {
        InitiateBillsTransferRequest copy = new InitiateBillsTransferRequest();
        copy.appid = appid;
        copy.outBatchNo = outBatchNo;
        copy.transferSceneId = transferSceneId;
        copy.openid = openid;
        copy.userName = userName;
        if (userName != null && !userName.isEmpty()) {
            copy.userName = s.apply(userName);
        }
        copy.transferAmount = transferAmount;
        copy.transferRemark = transferRemark;
        copy.notifyUrl = notifyUrl;
        copy.userRecvPerception = userRecvPerception;
        if (transferSceneReportInfo != null && transferSceneReportInfo.size() != 0) {
            // arr
            copy.transferSceneReportInfo = new ArrayList<>();
            for (com.wechat.pay.java.service.transferbills.model.TransferSceneReportInfo val : transferSceneReportInfo) {
                if (val != null) {
                    copy.transferSceneReportInfo.add(val.cloneWithCipher(s));
                }
            }
        }
        return copy;
    }
}
