// Copyright 2021 Tencent Inc. All rights reserved.
//
// 商家转账对外API
//
// * 场景及业务流程：     商户可通过该产品实现同时向多个用户微信零钱进行转账的操作，可用于发放奖金补贴、佣金货款结算、员工报销等场景。
// [https://pay.weixin.qq.com/index.php/public/product/detail?pid=108&productType=0](https://pay.weixin.qq.com/index.php/public/product/detail?pid=108&productType=0) * 接入步骤：     * 商户在微信支付商户平台开通“批量转账到零钱”产品权限，并勾选“使用API方式发起转账”。     * 调用批量转账接口，对多个用户微信零钱发起转账。     * 调用查询批次接口，可获取到转账批次详情及当前状态。     * 调用查询明细接口，可获取到单条转账明细详情及当前状态。
//
// API version: 1.0.5

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.transferbills.model;

import com.google.gson.annotations.SerializedName;

import java.util.function.UnaryOperator;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

/**
 * TransferSceneReportInfo
 */
public class TransferSceneReportInfo {

    /**
     * 【信息类型】 请根据产品文档确认当前转账场景下需传入的信息类型，需按要求填入，有多个字段时需填写完整
     * 如：转账场景为1000-现金营销，需填入活动名称、奖励说明
     */
    @SerializedName("info_type")
    private String infoType;

    /**
     * 【信息内容】 请根据信息类型，描述当前这笔转账单的转账背景
     * 如：
     * 信息类型为活动名称，请在信息内容描述用户参与活动的名称，如新会员有礼
     * 信息类型为奖励说明，请在信息内容描述用户因为什么奖励获取这笔资金，如注册会员抽奖一等奖
     */
    @SerializedName("info_content")
    private String infoContent;

    public String getInfoType() {
        return infoType;
    }

    public void setInfoType(String infoType) {
        this.infoType = infoType;
    }

    public String getInfoContent() {
        return infoContent;
    }

    public void setInfoContent(String infoContent) {
        this.infoContent = infoContent;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferSceneReportInfo {\n");
        sb.append("    infoType: ").append(toIndentedString(infoType)).append("\n");
        sb.append("    infoContent: ").append(toIndentedString(infoContent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public TransferSceneReportInfo cloneWithCipher(UnaryOperator<String> s) {
        TransferSceneReportInfo copy = new TransferSceneReportInfo();
        copy.infoType = infoType;
        copy.infoContent = infoContent;
        return copy;
    }

}
