/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.json;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import io.github.ibuildthecloud.gdapi.json.EscapeForwardSlash;
import io.github.ibuildthecloud.gdapi.json.JsonMapper;
import io.github.ibuildthecloud.gdapi.model.Field;
import io.github.ibuildthecloud.gdapi.model.Resource;
import io.github.ibuildthecloud.gdapi.model.Schema;
import io.github.ibuildthecloud.gdapi.model.SchemaCollection;
import io.github.ibuildthecloud.model.impl.FieldImpl;
import io.github.ibuildthecloud.model.impl.SchemaImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.PostConstruct;

public class JacksonMapper
implements JsonMapper {
    ObjectMapper mapper;
    boolean escapeForwardSlashes;

    @PostConstruct
    public void init() {
        SimpleModule module = new SimpleModule();
        module.setMixInAnnotation(Resource.class, ResourceMix.class);
        module.setMixInAnnotation(SchemaCollection.class, SchemaCollectionMixin.class);
        module.setMixInAnnotation(SchemaImpl.class, SchemaImplMixin.class);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.mapper = new ObjectMapper();
        this.mapper.setDateFormat((DateFormat)df);
        this.mapper.registerModule((Module)new JaxbAnnotationModule());
        this.mapper.registerModule((Module)module);
        this.mapper.getFactory().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (this.escapeForwardSlashes) {
            this.mapper.getFactory().setCharacterEscapes((CharacterEscapes)new EscapeForwardSlash());
        }
    }

    @Override
    public <T> T readValue(byte[] content, Class<T> type) throws IOException {
        return (T)this.mapper.readValue(content, type);
    }

    @Override
    public Object readValue(byte[] content) throws IOException {
        return this.mapper.readValue(content, Object.class);
    }

    @Override
    public void writeValue(OutputStream os, Object object) throws IOException {
        this.mapper.writeValue(os, object);
    }

    @Override
    public <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)this.mapper.convertValue(fromValue, toValueType);
    }

    public boolean isEscapeForwardSlashes() {
        return this.escapeForwardSlashes;
    }

    public void setEscapeForwardSlashes(boolean escapeForwardSlashes) {
        this.escapeForwardSlashes = escapeForwardSlashes;
    }

    public static interface ResourceMixin {
        @JsonAnyGetter
        public Map<String, Object> getFields();
    }

    public static interface SchemaImplMixin {
        @JsonDeserialize(as=Map.class, contentAs=FieldImpl.class)
        public Map<String, Field> getResourceFields();
    }

    public static interface SchemaCollectionMixin {
        @JsonDeserialize(as=List.class, contentAs=SchemaImpl.class)
        public List<Schema> getData();
    }

    public static interface ResourceMix {
        @JsonAnyGetter
        public Map<String, Object> getFields();
    }
}

