/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.model.impl;

import io.github.ibuildthecloud.gdapi.model.Field;
import io.github.ibuildthecloud.gdapi.model.FieldType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;

public class FieldImpl
implements Field {
    String name;
    String type;
    String validChars;
    String invalidChars;
    Integer displayIndex;
    boolean create;
    boolean update;
    boolean includeInList = true;
    boolean nullable;
    boolean unique;
    boolean required;
    boolean defaultIsNull = false;
    FieldType typeEnum;
    List<FieldType> subTypeEnums;
    List<String> subTypes;
    Long min;
    Long max;
    Long minLength;
    Long maxLength;
    Object defaultValue;
    List<String> options;
    Method readMethod;

    public FieldImpl() {
    }

    public FieldImpl(Field field) {
        this.name = field.getName();
        this.validChars = field.getValidChars();
        this.invalidChars = field.getInvalidChars();
        this.create = field.isCreate();
        this.update = field.isUpdate();
        this.includeInList = field.isIncludeInList();
        this.nullable = field.isNullable();
        this.unique = field.isUnique();
        this.required = field.isRequired();
        this.min = field.getMin();
        this.max = field.getMax();
        this.minLength = field.getMinLength();
        this.maxLength = field.getMaxLength();
        this.defaultValue = field.getDefault();
        this.options = field.getOptions() == null ? null : new ArrayList<String>(field.getOptions());
        this.displayIndex = field.getDisplayIndex();
        if (field instanceof FieldImpl) {
            this.readMethod = ((FieldImpl)field).getReadMethod();
            this.defaultIsNull = ((FieldImpl)field).isDefaultIsNull();
        }
        this.setType(field.getType());
    }

    @Override
    public Object getValue(Object object) {
        if (this.readMethod == null || object == null) {
            return null;
        }
        try {
            return this.readMethod.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    @XmlTransient
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isCreate() {
        return this.create;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    @Override
    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    @Override
    public boolean isIncludeInList() {
        return this.includeInList;
    }

    public void setIncludeInList(boolean includeInList) {
        this.includeInList = includeInList;
    }

    @Override
    public String getType() {
        if (this.type == null && this.typeEnum != null) {
            this.type = FieldType.toString(this.type, this.typeEnum, this.subTypes);
        }
        return this.type;
    }

    public void setType(String typeName) {
        if (typeName == null) {
            this.type = null;
        } else {
            List<FieldType.TypeAndName> parts = FieldType.parse(typeName);
            if (parts.size() == 0) {
                throw new IllegalArgumentException("Failed to parse type [" + typeName + "]");
            }
            FieldType.TypeAndName part = parts.get(0);
            this.type = part.getName();
            this.typeEnum = part.getType();
            parts.remove(0);
            this.setSubTypesList(parts);
        }
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public FieldType getTypeEnum() {
        return this.typeEnum;
    }

    public void setTypeEnum(FieldType typeEnum) {
        this.typeEnum = typeEnum;
        this.type = null;
        this.subTypeEnums = Collections.emptyList();
        this.subTypes = Collections.emptyList();
    }

    @Override
    public Long getMin() {
        return this.min;
    }

    public void setMin(Long min) {
        this.min = min;
    }

    @Override
    public Long getMax() {
        return this.max;
    }

    public void setMax(Long max) {
        this.max = max;
    }

    @Override
    public Long getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Long minLength) {
        this.minLength = minLength;
    }

    @Override
    public Long getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Long maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public Object getDefault() {
        if (this.defaultValue == null || this.typeEnum == null) {
            return this.defaultValue;
        }
        switch (this.typeEnum) {
            case BOOLEAN: {
                return Boolean.parseBoolean(this.defaultValue.toString());
            }
            case INT: {
                try {
                    return Long.parseLong(this.defaultValue.toString());
                }
                catch (NumberFormatException nfe) {
                    break;
                }
            }
        }
        return this.defaultValue;
    }

    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    @XmlTransient
    public Method getReadMethod() {
        return this.readMethod;
    }

    public void setReadMethod(Method readMethod) {
        this.readMethod = readMethod;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public String getValidChars() {
        return this.validChars;
    }

    public void setValidChars(String validChars) {
        this.validChars = validChars;
    }

    @Override
    public String getInvalidChars() {
        return this.invalidChars;
    }

    public void setInvalidChars(String invalidChars) {
        this.invalidChars = invalidChars;
    }

    public String toString() {
        return "FieldImpl [name=" + this.name + ", type=" + this.type + ", validChars=" + this.validChars + ", invalidChars=" + this.invalidChars + ", displayIndex=" + this.displayIndex + ", create=" + this.create + ", update=" + this.update + ", includeInList=" + this.includeInList + ", nullable=" + this.nullable + ", unique=" + this.unique + ", required=" + this.required + ", defaultIsNull=" + this.defaultIsNull + ", typeEnum=" + (Object)((Object)this.typeEnum) + ", subTypeEnums=" + this.subTypeEnums + ", subTypes=" + this.subTypes + ", min=" + this.min + ", max=" + this.max + ", minLength=" + this.minLength + ", maxLength=" + this.maxLength + ", defaultValue=" + this.defaultValue + ", options=" + this.options + ", readMethod=" + this.readMethod + "]";
    }

    public void setSubTypesList(List<FieldType.TypeAndName> subTypes) {
        this.subTypes = new ArrayList<String>(subTypes.size());
        this.subTypeEnums = new ArrayList<FieldType>(subTypes.size());
        for (FieldType.TypeAndName typeAndName : subTypes) {
            this.subTypes.add(typeAndName.getName());
            this.subTypeEnums.add(typeAndName.getType());
        }
        this.type = FieldType.toString(this.type, this.typeEnum, this.subTypes);
    }

    @Override
    public List<FieldType> getSubTypeEnums() {
        return this.subTypeEnums;
    }

    @Override
    public List<String> getSubTypes() {
        return this.subTypes;
    }

    @Override
    @XmlTransient
    public Integer getDisplayIndex() {
        return this.displayIndex;
    }

    public void setDisplayIndex(Integer displayIndex) {
        this.displayIndex = displayIndex;
    }

    @XmlTransient
    public boolean isDefaultIsNull() {
        return this.defaultIsNull;
    }

    public void setDefaultIsNull(boolean defaultIsNull) {
        this.defaultIsNull = defaultIsNull;
    }

    @Override
    public boolean hasDefault() {
        return this.defaultValue != null || this.defaultIsNull;
    }
}

