package io.github.ibuildthecloud.gdapi.util;

public class ExceptionUtils {

    @SuppressWarnings("unchecked")
    public static <T extends Throwable> void rethrow(Throwable t, Class<T> clz) throws T {
        if ( clz.isAssignableFrom(t.getClass()) )
            throw (T)t;
    }

    public static <T extends Throwable> void rethrowRuntime(Throwable t) {
        rethrow(t, RuntimeException.class);
        rethrow(t, Error.class);
    }

}
