/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.response;

import io.github.ibuildthecloud.gdapi.context.ApiContext;
import io.github.ibuildthecloud.gdapi.factory.SchemaFactory;
import io.github.ibuildthecloud.gdapi.json.JsonMapper;
import io.github.ibuildthecloud.gdapi.model.Collection;
import io.github.ibuildthecloud.gdapi.model.Resource;
import io.github.ibuildthecloud.gdapi.model.Schema;
import io.github.ibuildthecloud.gdapi.model.impl.CollectionImpl;
import io.github.ibuildthecloud.gdapi.model.impl.WrappedResource;
import io.github.ibuildthecloud.gdapi.request.ApiRequest;
import io.github.ibuildthecloud.gdapi.request.handler.AbstractApiRequestHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.inject.Inject;

public class JsonResponseWriter
extends AbstractApiRequestHandler {
    JsonMapper jsonMapper;
    boolean chunked = false;

    @Override
    public void handle(ApiRequest request) throws IOException {
        if (request.isCommitted()) {
            return;
        }
        if (!this.getResponseFormat().equals(request.getResponseFormat())) {
            return;
        }
        Object responseObject = this.getResponseObject(request);
        if (responseObject == null) {
            return;
        }
        request.setResponseContentType(this.getContentType());
        OutputStream os = request.getOutputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeJson(this.chunked ? os : baos, responseObject, request);
        if (!this.chunked) {
            byte[] bytes = baos.toByteArray();
            request.getServletContext().getResponse().setContentLength(bytes.length);
            os.write(bytes);
            os.flush();
        }
    }

    protected String getContentType() {
        return "application/json; charset=utf-8";
    }

    protected String getResponseFormat() {
        return "json";
    }

    protected Object getResponseObject(ApiRequest request) {
        Object object = request.getResponseObject();
        if (object instanceof List) {
            return this.createCollection((List)object, request);
        }
        if (object instanceof Collection) {
            return object;
        }
        return this.createResource(request.getSchemaFactory(), object);
    }

    protected Collection createCollection(List<?> list, ApiRequest request) {
        CollectionImpl collection = new CollectionImpl();
        collection.setResourceType(request.getType());
        for (Object obj : list) {
            Resource resource = this.createResource(request.getSchemaFactory(), obj);
            if (resource == null) continue;
            collection.getData().add(resource);
            if (collection.getResourceType() != null) continue;
            collection.setResourceType(resource.getType());
        }
        return collection;
    }

    protected Resource createResource(SchemaFactory schemaFactory, Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Resource) {
            return (Resource)obj;
        }
        Schema schema = schemaFactory.getSchema(obj.getClass());
        ApiContext apiContext = ApiContext.getContext();
        return schema == null ? null : new WrappedResource(apiContext.getIdFormatter(), schema, obj, apiContext.getApiRequest().getMethod());
    }

    protected void writeJson(OutputStream os, Object responseObject, ApiRequest request) throws IOException {
        this.jsonMapper.writeValue(os, responseObject);
    }

    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    @Inject
    public void setJsonMapper(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }
}

