/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.factory.impl;

import io.github.ibuildthecloud.gdapi.factory.SchemaFactory;
import io.github.ibuildthecloud.gdapi.factory.impl.AbstractSchemaFactory;
import io.github.ibuildthecloud.gdapi.factory.impl.SchemaPostProcessor;
import io.github.ibuildthecloud.gdapi.model.Field;
import io.github.ibuildthecloud.gdapi.model.FieldType;
import io.github.ibuildthecloud.gdapi.model.Filter;
import io.github.ibuildthecloud.gdapi.model.Schema;
import io.github.ibuildthecloud.gdapi.model.impl.SchemaImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class SubSchemaFactory
extends AbstractSchemaFactory
implements SchemaFactory {
    SchemaFactory schemaFactory;
    String id;
    Map<String, Schema> schemaMap;
    List<SchemaImpl> schemaList = new ArrayList<SchemaImpl>();
    List<SchemaPostProcessor> postProcessors = new ArrayList<SchemaPostProcessor>();
    boolean init = false;

    /*
     * WARNING - void declaration
     */
    public synchronized void init() {
        if (this.init) {
            return;
        }
        this.schemaMap = new HashMap<String, Schema>();
        if (this.schemaFactory instanceof SubSchemaFactory) {
            ((SubSchemaFactory)this.schemaFactory).init();
        }
        ArrayList<SchemaImpl> result = new ArrayList<SchemaImpl>();
        for (Schema schema : this.schemaFactory.listSchemas()) {
            SchemaPostProcessor post;
            if (!(schema instanceof SchemaImpl)) continue;
            SchemaImpl impl = new SchemaImpl((SchemaImpl)schema);
            Iterator<SchemaPostProcessor> i$ = this.postProcessors.iterator();
            while (i$.hasNext() && (impl = (post = i$.next()).postProcessRegister(impl, this)) != null) {
            }
            if (impl == null) continue;
            result.add(impl);
            this.schemaMap.put(impl.getId(), impl);
        }
        this.schemaList = result;
        for (SchemaImpl schemaImpl : this.schemaList) {
            for (SchemaPostProcessor post : this.postProcessors) {
                void var3_6;
                SchemaImpl schemaImpl2 = post.postProcess((SchemaImpl)var3_6, this);
            }
        }
        for (SchemaImpl schemaImpl : this.schemaList) {
            this.prune(schemaImpl);
        }
        this.init = true;
    }

    protected void prune(SchemaImpl schema) {
        Map<String, Field> fields = schema.getResourceFields();
        Map<String, Filter> filters = schema.getCollectionFilters();
        block0: for (String name : new HashSet<String>(fields.keySet())) {
            Field field = fields.get(name);
            List<FieldType> subTypeEnums = field.getSubTypeEnums();
            List<String> subTypes = field.getSubTypes();
            for (int i = 0; i < subTypeEnums.size(); ++i) {
                if (subTypeEnums.get(i) != FieldType.TYPE || this.schemaMap.containsKey(subTypes.get(i)) || "type".equals(subTypes.get(i))) continue;
                fields.remove(name);
                filters.remove(name);
                continue block0;
            }
        }
        Iterator<String> childrenIter = schema.getChildren().iterator();
        while (childrenIter.hasNext()) {
            if (this.schemaMap.containsKey(childrenIter.next())) continue;
            childrenIter.remove();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<Schema> listSchemas() {
        return this.schemaList;
    }

    @Override
    public Schema getSchema(Class<?> clz) {
        return this.getSchema(this.schemaFactory.getSchemaName(clz));
    }

    @Override
    public Schema getSchema(String type) {
        Schema parentSchema = this.schemaFactory.getSchema(type);
        return parentSchema == null ? null : this.schemaMap.get(parentSchema.getId());
    }

    @Override
    public Class<?> getSchemaClass(String type) {
        Schema schema = this.getSchema(type);
        return schema == null ? null : this.schemaFactory.getSchemaClass(type);
    }

    @Override
    public Schema registerSchema(Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Schema parseSchema(String name) {
        throw new UnsupportedOperationException();
    }

    public SchemaFactory getSchemaFactory() {
        return this.schemaFactory;
    }

    public List<SchemaPostProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    public void setPostProcessors(List<SchemaPostProcessor> postProcessors) {
        this.postProcessors = postProcessors;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Inject
    public void setSchemaFactory(SchemaFactory schemaFactory) {
        this.schemaFactory = schemaFactory;
    }
}

