/*
 * Decompiled with CFR 0.152.
 */
package io.github.interacto.undo;

import io.github.interacto.undo.Undoable;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.ResourceBundle;

public class UndoCollector {
    private static UndoCollector instance = new UndoCollector();
    public static final String EMPTY_REDO = "redo";
    public static final String EMPTY_UNDO = "undo";
    private final Deque<Undoable> undo = new ArrayDeque<Undoable>();
    private final Deque<Undoable> redo = new ArrayDeque<Undoable>();
    private int sizeMax = 30;
    private ResourceBundle bundle;
    private final PublishSubject<Optional<Undoable>> undoPublisher = PublishSubject.create();
    private final PublishSubject<Optional<Undoable>> redoPublisher = PublishSubject.create();

    public static UndoCollector getInstance() {
        return instance;
    }

    public static void setInstance(UndoCollector newInstance) {
        if (newInstance != null) {
            instance = newInstance;
        }
    }

    public Observable<Optional<Undoable>> undos() {
        return this.undoPublisher;
    }

    public Observable<Optional<Undoable>> redos() {
        return this.redoPublisher;
    }

    public void clear() {
        if (!this.undo.isEmpty()) {
            this.undo.clear();
            this.undoPublisher.onNext(Optional.empty());
        }
        this.clearRedo();
    }

    private void clearRedo() {
        if (!this.redo.isEmpty()) {
            this.redo.clear();
            this.redoPublisher.onNext(Optional.empty());
        }
    }

    public void add(Undoable undoable) {
        if (undoable != null && this.sizeMax > 0) {
            if (this.undo.size() == this.sizeMax) {
                this.undo.removeLast();
            }
            this.undo.push(undoable);
            this.undoPublisher.onNext(Optional.of(undoable));
            this.clearRedo();
        }
    }

    public void undo() {
        if (!this.undo.isEmpty()) {
            Undoable undoable = this.undo.pop();
            undoable.undo();
            this.redo.push(undoable);
            this.undoPublisher.onNext(this.getLastUndo());
            this.redoPublisher.onNext(Optional.of(undoable));
        }
    }

    public void redo() {
        if (!this.redo.isEmpty()) {
            Undoable undoable = this.redo.pop();
            undoable.redo();
            this.undo.push(undoable);
            this.undoPublisher.onNext(Optional.of(undoable));
            this.redoPublisher.onNext(this.getLastRedo());
        }
    }

    public Optional<String> getLastUndoMessage() {
        return this.undo.isEmpty() ? Optional.empty() : Optional.ofNullable(this.undo.peek().getUndoName(this.bundle));
    }

    public Optional<String> getLastRedoMessage() {
        return this.redo.isEmpty() ? Optional.empty() : Optional.ofNullable(this.redo.peek().getUndoName(this.bundle));
    }

    public Optional<Undoable> getLastUndo() {
        return Optional.ofNullable(this.undo.peek());
    }

    public Optional<Undoable> getLastRedo() {
        return Optional.ofNullable(this.redo.peek());
    }

    public int getSizeMax() {
        return this.sizeMax;
    }

    public void setSizeMax(int max) {
        if (max >= 0) {
            boolean removed = false;
            int nb = this.undo.size() - max;
            for (int i = 0; i < nb; ++i) {
                this.undo.removeLast();
                removed = true;
            }
            if (removed && this.undo.isEmpty()) {
                this.undoPublisher.onNext(Optional.empty());
            }
            this.sizeMax = max;
        }
    }

    public Deque<Undoable> getUndo() {
        return this.undo;
    }

    public Deque<Undoable> getRedo() {
        return this.redo;
    }

    public void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }
}

