/*
 * Decompiled with CFR 0.152.
 */
package io.github.interacto.binding;

import io.github.interacto.binding.MustBeUndoableCmdException;
import io.github.interacto.binding.WidgetBinding;
import io.github.interacto.command.Command;
import io.github.interacto.command.CommandsRegistry;
import io.github.interacto.error.ErrorCatcher;
import io.github.interacto.fsm.CancelFSMException;
import io.github.interacto.fsm.FSM;
import io.github.interacto.interaction.InteractionData;
import io.github.interacto.interaction.InteractionImpl;
import io.github.interacto.undo.Undoable;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class WidgetBindingImpl<C extends Command, I extends InteractionImpl<D, ?, ?>, D extends InteractionData>
implements WidgetBinding<C> {
    private static Logger logger = Logger.getLogger(WidgetBinding.class.getName());
    protected long timeEnded;
    protected long timeCancelled;
    protected Logger loggerBinding;
    protected Logger loggerCmd;
    protected boolean activated;
    protected final I interaction;
    protected C cmd;
    protected final boolean continuousCmdExec;
    protected boolean async;
    protected final Function<D, C> cmdProducer;
    protected final PublishSubject<C> cmdsProduced;

    public static void setLogger(Logger logger) {
        if (logger != null) {
            WidgetBindingImpl.logger = logger;
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public WidgetBindingImpl(boolean continuousExecution, Function<D, C> cmdCreation, I interaction) {
        if (cmdCreation == null || interaction == null) {
            throw new IllegalArgumentException();
        }
        this.timeCancelled = 0L;
        this.timeEnded = 0L;
        this.cmdsProduced = PublishSubject.create();
        this.cmdProducer = cmdCreation;
        this.interaction = interaction;
        this.cmd = null;
        this.continuousCmdExec = continuousExecution;
        this.activated = true;
        ((FSM)((InteractionImpl)this.interaction).getFsm()).addHandler(this);
        this.async = false;
    }

    public void logBinding(boolean log) {
        if (log) {
            if (this.loggerBinding == null) {
                this.loggerBinding = logger;
            }
        } else {
            this.loggerBinding = null;
        }
    }

    public void logCmd(boolean log) {
        if (log) {
            if (this.loggerCmd == null) {
                this.loggerCmd = logger;
            }
        } else {
            this.loggerCmd = null;
        }
    }

    public void logInteraction(boolean log) {
        ((InteractionImpl)this.interaction).log(log);
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean asyncCmd) {
        this.async = asyncCmd;
    }

    @Override
    public void clearEvents() {
        ((InteractionImpl)this.interaction).fullReinit();
    }

    protected C createCommand() {
        try {
            return (C)((Command)this.cmdProducer.apply(((InteractionImpl)this.interaction).getData()));
        }
        catch (Exception ex) {
            ErrorCatcher.getInstance().reportError(ex);
            return null;
        }
    }

    @Override
    public void first() {
    }

    @Override
    public void then() {
    }

    @Override
    public void end() {
    }

    @Override
    public void cancel() {
    }

    @Override
    public void endOrCancel() {
    }

    @Override
    public void ifCmdHadNoEffect() {
    }

    @Override
    public void ifCmdHadEffects() {
    }

    @Override
    public void ifCannotExecuteCmd() {
    }

    @Override
    public abstract boolean when();

    public I getInteraction() {
        return this.interaction;
    }

    @Override
    public C getCommand() {
        return this.cmd;
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public boolean isRunning() {
        return ((InteractionImpl)this.interaction).isRunning();
    }

    @Override
    public boolean isStrictStart() {
        return false;
    }

    protected abstract void unbindCmdAttributes();

    @Override
    public void fsmCancels() {
        if (this.cmd != null) {
            if (this.loggerBinding != null) {
                this.loggerBinding.log(Level.INFO, "Binding cancelled");
            }
            boolean hadEffects = this.cmd.hadEffect();
            this.cmd.cancel();
            if (this.loggerCmd != null) {
                this.loggerCmd.log(Level.INFO, "Command cancelled");
            }
            this.unbindCmdAttributes();
            if (this.isContinuousCmdExec() && hadEffects) {
                this.cancelContinousWithEffectsCmd();
            }
            this.cmd = null;
            this.cancel();
            this.endOrCancel();
            ++this.timeCancelled;
        }
    }

    private void cancelContinousWithEffectsCmd() {
        if (this.cmd instanceof Undoable) {
            ((Undoable)this.cmd).undo();
            if (this.loggerCmd != null) {
                this.loggerCmd.log(Level.INFO, "Command undone");
            }
        } else {
            throw new MustBeUndoableCmdException(this.cmd.getClass());
        }
    }

    @Override
    public void fsmStarts() throws CancelFSMException {
        if (!this.isActivated()) {
            return;
        }
        boolean ok = this.when();
        if (this.loggerBinding != null) {
            this.loggerBinding.log(Level.INFO, "Starting binding: " + ok);
        }
        if (ok) {
            this.cmd = this.createCommand();
            if (this.cmd != null) {
                this.first();
                if (this.loggerCmd != null) {
                    this.loggerCmd.log(Level.INFO, "Command created and init: " + this.cmd);
                }
            }
        } else if (this.isStrictStart()) {
            if (this.loggerBinding != null) {
                this.loggerBinding.log(Level.INFO, "Cancelling starting interaction: " + this.interaction);
            }
            throw new CancelFSMException();
        }
    }

    @Override
    public void fsmUpdates() {
        if (!this.isActivated()) {
            return;
        }
        if (this.loggerBinding != null) {
            this.loggerBinding.log(Level.INFO, "Binding updates");
        }
        if (this.createAndInitCommand()) {
            if (this.loggerCmd != null) {
                this.loggerCmd.log(Level.INFO, "Command update");
            }
            this.then();
            if (this.continuousCmdExec) {
                if (this.loggerCmd != null) {
                    this.loggerCmd.log(Level.INFO, "Try to execute command (continuous execution)");
                }
                boolean ok = this.cmd.doIt();
                if (this.loggerCmd != null) {
                    this.loggerCmd.log(Level.INFO, "Continuous command execution had this result: " + ok);
                }
                if (!ok) {
                    this.ifCannotExecuteCmd();
                }
            }
        }
    }

    @Override
    public void fsmStops() {
        if (!this.isActivated()) {
            return;
        }
        if (this.loggerBinding != null) {
            this.loggerBinding.log(Level.INFO, "Binding stops");
        }
        if (this.createAndInitCommand()) {
            if (!this.continuousCmdExec) {
                this.then();
                if (this.loggerCmd != null) {
                    this.loggerCmd.log(Level.INFO, "Command updated: " + this.cmd);
                }
            }
            this.executeCmd(this.cmd, this.async);
            this.unbindCmdAttributes();
            this.cmd = null;
            ++this.timeEnded;
        } else if (this.cmd != null) {
            if (this.loggerCmd != null) {
                this.loggerCmd.log(Level.INFO, "Cancelling the command: " + this.cmd);
            }
            this.cmd.cancel();
            this.unbindCmdAttributes();
            this.cmd = null;
            ++this.timeCancelled;
        }
    }

    protected boolean createAndInitCommand() {
        boolean ok = this.when();
        if (this.loggerBinding != null) {
            this.loggerBinding.log(Level.INFO, "when predicate is {}", ok);
        }
        if (ok && this.cmd == null) {
            if (this.loggerCmd != null) {
                this.loggerCmd.log(Level.INFO, "Command creation");
            }
            this.cmd = this.createCommand();
            boolean bl = ok = this.cmd != null;
            if (ok) {
                this.first();
            }
        }
        return ok;
    }

    private void executeCmd(C cmd, boolean async) {
        if (async) {
            this.executeCmdAsync((Command)cmd);
        } else {
            this.afterCmdExecuted(cmd, cmd.doIt());
        }
    }

    protected abstract void executeCmdAsync(Command var1);

    protected void afterCmdExecuted(C cmd, boolean ok) {
        if (this.loggerCmd != null) {
            this.loggerCmd.log(Level.INFO, "Command execution had this result: " + ok);
        }
        if (ok) {
            this.end();
            this.endOrCancel();
        } else {
            this.ifCannotExecuteCmd();
        }
        if (cmd.getStatus() != Command.CmdStatus.EXECUTED) {
            return;
        }
        cmd.done();
        this.cmdsProduced.onNext(cmd);
        boolean hadEffect = cmd.hadEffect();
        if (this.loggerCmd != null) {
            this.loggerCmd.log(Level.INFO, "Command execution had effect: " + hadEffect);
        }
        if (hadEffect) {
            if (cmd.getRegistrationPolicy() != Command.RegistrationPolicy.NONE) {
                CommandsRegistry.getInstance().addCommand((Command)cmd);
            } else {
                CommandsRegistry.getInstance().removeCommand((Command)cmd);
            }
            this.ifCmdHadEffects();
        } else {
            this.ifCmdHadNoEffect();
        }
    }

    @Override
    public void uninstallBinding() {
        this.setActivated(false);
        this.cmdsProduced.onComplete();
        this.loggerCmd = null;
        this.loggerBinding = null;
        ((InteractionImpl)this.interaction).uninstall();
    }

    @Override
    public boolean isContinuousCmdExec() {
        return this.continuousCmdExec;
    }

    @Override
    public void setActivated(boolean activated) {
        this.activated = activated;
        if (this.loggerBinding != null) {
            this.loggerBinding.log(Level.INFO, "Binding Activated: " + activated);
        }
        ((InteractionImpl)this.interaction).setActivated(activated);
        if (!activated && this.cmd != null) {
            this.unbindCmdAttributes();
            this.cmd.flush();
            this.cmd = null;
        }
    }

    @Override
    public Observable<C> produces() {
        return this.cmdsProduced;
    }

    @Override
    public long getTimesEnded() {
        return this.timeEnded;
    }

    @Override
    public long getTimesCancelled() {
        return this.timeCancelled;
    }
}

