/*
 * Decompiled with CFR 0.152.
 */
package io.github.interacto.fsm;

import io.github.interacto.fsm.CancelFSMException;
import io.github.interacto.fsm.FSM;
import io.github.interacto.fsm.FSMHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ConcurrentFSM<E, F extends FSM<E>>
extends FSM<E> {
    private final List<F> conccurFSMs;

    public ConcurrentFSM(Set<F> fsms) {
        if (fsms == null || fsms.size() < 2) {
            throw new IllegalArgumentException("Requires more that 1 FSM");
        }
        this.conccurFSMs = new ArrayList<F>(fsms);
        this.conccurFSMs.forEach(fsm -> fsm.addHandler(new FSMHandler(){

            @Override
            public void fsmStarts() throws CancelFSMException {
                if (ConcurrentFSM.this.isStarted()) {
                    ConcurrentFSM.this.onStarting();
                }
            }

            @Override
            public void fsmUpdates() throws CancelFSMException {
                ConcurrentFSM.this.onUpdating();
            }

            @Override
            public void fsmStops() throws CancelFSMException {
                ConcurrentFSM.this.onTerminating();
            }

            @Override
            public void fsmCancels() {
                ConcurrentFSM.this.onCancelling();
            }
        }));
    }

    public List<F> getConccurFSMs() {
        return Collections.unmodifiableList(this.conccurFSMs);
    }

    @Override
    public boolean process(E event) {
        for (FSM conccurFSM : this.conccurFSMs) {
            if (!conccurFSM.process(event)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStarted() {
        return this.conccurFSMs.stream().allMatch(fsm -> fsm.isStarted());
    }

    @Override
    public void log(boolean log) {
        super.log(log);
        this.conccurFSMs.forEach(fsm -> fsm.log(log));
    }

    @Override
    public void uninstall() {
        super.uninstall();
        this.conccurFSMs.forEach(fsm -> fsm.uninstall());
    }
}

