/*
 * Decompiled with CFR 0.152.
 */
package io.github.interestinglab.waterdrop.flink.source;

import io.github.interestinglab.waterdrop.common.config.CheckResult;
import io.github.interestinglab.waterdrop.config.Config;
import io.github.interestinglab.waterdrop.flink.FlinkEnvironment;
import io.github.interestinglab.waterdrop.flink.stream.FlinkStreamSource;
import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.scala.typeutils.Types;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.types.Row;

public class SocketStream
implements FlinkStreamSource<Row> {
    private Config config;
    private static final String HOST = "host";
    private static final String PORT = "port";
    private String host = "localhost";
    private int port = 9999;

    public DataStream<Row> getData(FlinkEnvironment env) {
        StreamExecutionEnvironment environment = env.getStreamExecutionEnvironment();
        SingleOutputStreamOperator operator = environment.socketTextStream(this.host, this.port).map((MapFunction & Serializable)value -> {
            Row row = new Row(1);
            row.setField(0, value);
            return row;
        }).returns((TypeInformation)new RowTypeInfo(new TypeInformation[]{Types.STRING()}));
        return operator;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public CheckResult checkConfig() {
        return new CheckResult(true, "");
    }

    public void prepare(FlinkEnvironment prepareEnv) {
        if (this.config.hasPath(HOST)) {
            this.host = this.config.getString(HOST);
        }
        if (this.config.hasPath(PORT)) {
            this.port = this.config.getInt(PORT);
        }
    }
}

