/*
 * Decompiled with CFR 0.152.
 */
package org.SpurQLabs.Core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.microsoft.playwright.ElementHandle;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.options.SelectOption;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.SpurQLabs.Core.Element;
import org.SpurQLabs.Core.WebPage;
import org.SpurQLabs.Utilities.CommonUtil;
import org.apache.logging.log4j.Logger;

public class BasePage {
    protected Page page;
    protected Logger logger;
    protected Gson gson;
    protected HashMap<String, String> temp;

    public BasePage(Page page, Logger logger) {
        this.page = page;
        this.logger = logger;
        this.gson = new GsonBuilder().create();
        this.temp = new HashMap();
    }

    public WebPage createPage(String filePath) {
        try {
            String jsonContent = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
            return (WebPage)this.gson.fromJson(jsonContent, WebPage.class);
        }
        catch (IOException e) {
            this.logger.warn("Error reading JSON file: {}", (Object)e.getMessage());
            return null;
        }
    }

    public WebPage getPage(String pageName) {
        try {
            String jsonFilePath = CommonUtil.getFrameworkConfig("JsonFilePath") + pageName + ".json";
            String jsonContent = new String(Files.readAllBytes(Paths.get(jsonFilePath, new String[0])));
            return (WebPage)this.gson.fromJson(jsonContent, WebPage.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid page or Invalid JSON file", e);
        }
    }

    public String getElementFromPage(String key, String pageName) {
        try {
            Element element;
            List<String> xpaths;
            Optional<Element> elementOptional;
            WebPage page = this.getPage(pageName);
            if (page != null && page.getElements() != null && (elementOptional = page.getElements().stream().filter(e -> key.equals(e.getElementName())).findFirst()).isPresent() && !(xpaths = List.of((element = elementOptional.get()).getXpaths())).isEmpty()) {
                return xpaths.get(0);
            }
            return null;
        }
        catch (Exception ex) {
            this.logger.warn("Error getting element from page: {}" + ex.getMessage());
            return null;
        }
    }

    private String getElementName(String key, String pageName) {
        Element element = this.getElementDetailsFromPage(key, pageName);
        return element != null ? element.getElementName() : "";
    }

    public Element getElementDetailsFromPage(String elementName, String pageName) {
        try {
            WebPage page = this.getPage(pageName);
            if (page != null) {
                Optional<Element> elementOptional = page.getElements().stream().filter(e -> elementName.equals(e.getElementName())).findFirst();
                return elementOptional.orElse(null);
            }
            return null;
        }
        catch (Exception ex) {
            this.logger.warn("Error getting element details from page: {}", (Object)ex.getMessage());
            return null;
        }
    }

    public ElementHandle getWebElement(Element jsonElement, String valueToSet) {
        List<String> locator = List.of("Xpaths", "Id", "Name");
        ElementHandle elementHandle = null;
        for (String by : locator) {
            ElementHandle element = this.findElementByXpath(by, jsonElement, valueToSet);
            if (element == null) continue;
            elementHandle = element;
            break;
        }
        return elementHandle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ElementHandle findElementByXpath(String locator, Element jsonElement, String valueToSet) {
        ElementHandle elementHandle = null;
        String selector = "";
        if (jsonElement != null) {
            switch (locator) {
                case "Id": {
                    if (!jsonElement.getId().equals("")) {
                        selector = this.getSelector(jsonElement.getId(), valueToSet);
                        List elementsById = this.page.querySelectorAll(selector);
                        if (elementsById.size() != 1) return elementHandle;
                        elementHandle = (ElementHandle)elementsById.get(0);
                        this.scrollToElement(elementHandle);
                        return elementHandle;
                    }
                    System.out.println("No Id value is present in the DOM for the element");
                    return elementHandle;
                }
                case "Name": {
                    if (!jsonElement.getName().equals("")) {
                        selector = this.getSelector(jsonElement.getName(), valueToSet);
                        List elementsByName = this.page.querySelectorAll(selector);
                        if (elementsByName.size() != 1) return elementHandle;
                        elementHandle = (ElementHandle)elementsByName.get(0);
                        this.scrollToElement(elementHandle);
                        return elementHandle;
                    }
                    System.out.println("No Name value is present in the DOM for the element");
                    return elementHandle;
                }
                case "Xpaths": {
                    for (String xpath : jsonElement.getXpaths()) {
                        List elementsByXpath;
                        if (xpath == null || (elementsByXpath = this.page.querySelectorAll(selector = this.getSelector(xpath, valueToSet))).size() != 1) continue;
                        elementHandle = (ElementHandle)elementsByXpath.get(0);
                        this.scrollToElement(elementHandle);
                    }
                    return elementHandle;
                }
            }
            return elementHandle;
        }
        System.out.println("The JSON file does not contain information of the passed element");
        return elementHandle;
    }

    private String getSelector(String baseSelector, String valueToSet) {
        if (baseSelector.contains("radiobuttonlabel")) {
            return baseSelector.replace("radiobuttonlabel", valueToSet);
        }
        if (baseSelector.contains("textlabel")) {
            return baseSelector.replace("textlabel", valueToSet);
        }
        if (baseSelector.contains("checkboxlabel")) {
            return baseSelector.replace("checkboxlabel", valueToSet);
        }
        return baseSelector;
    }

    public void performActionOnElement(String elementName, String currentPageName, String valueToSet) throws InterruptedException {
        if (this.page == null) {
            System.out.println("Browser Page is null here");
        }
        this.logger.info(this.getClass().getSimpleName() + "-" + currentPageName + "-" + elementName + "-" + valueToSet);
        Element elementDetails = this.getElementDetailsFromPage(elementName, currentPageName);
        switch (elementDetails.getElementType()) {
            case "Button": 
            case "Checkbox": 
            case "InputDropdownOption": 
            case "Radio": {
                this.Click(elementDetails, valueToSet);
                break;
            }
            case "TextInput": {
                this.SetValue(elementDetails, valueToSet);
                if (!"Creation_Name".equals(elementName)) break;
                this.storeText(elementName, valueToSet);
                break;
            }
            case "VerifyText": {
                this.verification(elementDetails, valueToSet);
                break;
            }
            case "VerifyAlert": {
                this.Verify(elementDetails);
                break;
            }
            case "SelectDropdwon": {
                this.SelectDropDown(elementDetails, valueToSet);
                break;
            }
            case "InputDropdown": {
                this.SetValue(elementDetails, valueToSet);
                break;
            }
        }
    }

    public void storeText(String verifyKey, String value) {
        this.logger.info("Storing value: " + value + " for key: " + verifyKey);
        this.temp.put(verifyKey, value);
    }

    public boolean isElementInViewPort(ElementHandle element) {
        System.out.println("Checking whether element is present on page: " + element);
        return (Boolean)this.page.evaluate("element => {  const box = element.getBoundingClientRect();  const cx = box.left + box.width / 2;  const cy = box.top + box.height / 2;  const e = document.elementFromPoint(cx, cy);  for (let currentElement = e; currentElement; currentElement = currentElement.parentElement) {    if (currentElement === element)      return true;  }  return false;}", (Object)element);
    }

    public void scrollToElement(ElementHandle element) {
        System.out.println("Scrolling to element: " + element);
        try {
            element.scrollIntoViewIfNeeded();
        }
        catch (PlaywrightException e) {
            System.out.println("Error scrolling into view: " + e.getMessage());
        }
    }

    public void scrollToPageByPixel(int pixels) {
        System.out.println("Scrolling page by " + pixels + " pixels");
        this.page.evaluate("pixels => { window.scrollBy(0, pixels); }", (Object)pixels);
    }

    public boolean verification(Element verifyValue, String verifyKey) {
        this.logger.info(this.getClass().getSimpleName() + "-" + verifyValue);
        try {
            if (!verifyKey.isEmpty()) {
                ElementHandle elem = this.getWebElement(verifyValue, verifyKey);
                return elem.isVisible();
            }
            ElementHandle element = this.getWebElement(verifyValue, "");
            return element.isVisible();
        }
        catch (Exception e) {
            this.logger.error("Verification failed for web element: " + verifyValue);
            return false;
        }
    }

    private void Click(Element ElementLocator, String valueToSet) throws InterruptedException {
        this.logger.info(this.getClass().getSimpleName() + "-" + ElementLocator);
        ElementHandle Elem = this.getWebElement(ElementLocator, valueToSet);
        Elem.click();
    }

    private void SetValue(Element ElementDetails, String ValueToSet) throws InterruptedException {
        this.logger.info(this.getClass().getSimpleName() + "-" + ElementDetails + "-" + ValueToSet);
        if (ValueToSet == null) {
            return;
        }
        ElementHandle element = this.getWebElement(ElementDetails, ValueToSet);
        if (element.isEnabled()) {
            element.click();
            element.focus();
            this.page.keyboard().press("Control+A");
            this.page.keyboard().press("Backspace");
            Thread.sleep(2000L);
            element.fill(ValueToSet);
        }
    }

    private boolean Verify(Element ElementName) {
        ElementHandle element = this.getWebElement(ElementName, "");
        try {
            return element.isVisible();
        }
        catch (Exception e) {
            this.logger.error("Verification failed for web element: " + ElementName);
            return false;
        }
    }

    private void SelectDropDown(Element ElementName, String DropDownOptoin) {
        ElementHandle element = this.getWebElement(ElementName, "");
        if (element.isEnabled()) {
            element.click();
            try {
                element.selectOption(DropDownOptoin);
            }
            catch (PlaywrightException e) {
                element.selectOption(new SelectOption().setLabel(DropDownOptoin));
            }
        }
    }

    public boolean VerifySelected(String ElementName, String currentPageName) {
        Element elementDetails = this.getElementDetailsFromPage(ElementName, currentPageName);
        ElementHandle element = this.getWebElement(elementDetails, "");
        try {
            return element.isChecked();
        }
        catch (PlaywrightException e) {
            System.err.println("The element is not selected: " + ElementName);
            return false;
        }
    }
}

