/*
 * Decompiled with CFR 0.152.
 */
package org.SpurQLabs.Core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.microsoft.playwright.ElementHandle;
import com.microsoft.playwright.Locator;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.options.ScreenshotType;
import com.microsoft.playwright.options.SelectOption;
import com.microsoft.playwright.options.WaitForSelectorState;
import io.cucumber.java.Scenario;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.SpurQLabs.Core.Element;
import org.SpurQLabs.Core.JsonPage;
import org.SpurQLabs.Utilities.CommonUtil;
import org.apache.logging.log4j.Logger;
import org.testng.Assert;

public class BasePage {
    public static Page page;
    public static Logger logger;
    protected Gson gson;
    protected HashMap<String, String> temp;
    public static byte[] array;
    public static int count;
    public static Scenario scenario;

    public BasePage(Page page, Logger logger, Scenario scenario1) {
        BasePage.page = page;
        BasePage.logger = logger;
        this.gson = new GsonBuilder().create();
        this.temp = new HashMap();
        scenario = scenario1;
    }

    public JsonPage createPage(String filePath) {
        try {
            String jsonContent = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
            return (JsonPage)this.gson.fromJson(jsonContent, JsonPage.class);
        }
        catch (IOException e) {
            logger.warn("Error reading JSON file: {}", (Object)e.getMessage());
            return null;
        }
    }

    public JsonPage getPage(String pageName) {
        try {
            String jsonFilePath = CommonUtil.getFrameworkConfig("JsonFilePath") + pageName + ".json";
            String jsonContent = new String(Files.readAllBytes(Paths.get(jsonFilePath, new String[0])));
            return (JsonPage)this.gson.fromJson(jsonContent, JsonPage.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid page or Invalid JSON file", e);
        }
    }

    public String getElementFromPage(String key, String pageName) {
        try {
            Element element;
            List<String> xpaths;
            Optional<Element> elementOptional;
            JsonPage page = this.getPage(pageName);
            if (page != null && page.getElements() != null && (elementOptional = page.getElements().stream().filter(e -> key.equals(e.getElementName())).findFirst()).isPresent() && !(xpaths = List.of((element = elementOptional.get()).getXpaths())).isEmpty()) {
                return xpaths.get(0);
            }
            return null;
        }
        catch (Exception ex) {
            logger.warn("Error getting element from page: {}" + ex.getMessage());
            return null;
        }
    }

    private String getElementName(String key, String pageName) {
        Element element = this.getElementDetailsFromPage(key, pageName);
        return element != null ? element.getElementName() : "";
    }

    public Element getElementDetailsFromPage(String elementName, String pageName) {
        try {
            JsonPage page = this.getPage(pageName);
            if (page != null) {
                Optional<Element> elementOptional = page.getElements().stream().filter(e -> elementName.equals(e.getElementName())).findFirst();
                return elementOptional.orElse(null);
            }
            return null;
        }
        catch (Exception ex) {
            logger.warn("Error getting element details from page: {}", (Object)ex.getMessage());
            return null;
        }
    }

    public ElementHandle getWebElement(Element jsonElement, String valueToSet) {
        List<String> locator = List.of("Xpaths", "Id", "Name");
        ElementHandle elementHandle = null;
        for (String by : locator) {
            ElementHandle element = this.findElementByXpath(by, jsonElement, valueToSet);
            if (element == null) continue;
            elementHandle = element;
            break;
        }
        return elementHandle;
    }

    public Locator pageGetWebElement(Element jsonElement, String valueToSet) {
        List<String> locator = List.of("Xpaths", "Id", "Name");
        Object elementHandle = null;
        Locator locator1 = null;
        for (String by : locator) {
            Locator element = this.findPageElementByXpath(by, jsonElement, valueToSet);
            if (element == null) continue;
            locator1 = element;
            break;
        }
        return locator1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ElementHandle findElementByXpath(String locator, Element jsonElement, String valueToSet) {
        ElementHandle elementHandle = null;
        String selector = "";
        if (jsonElement != null) {
            switch (locator) {
                case "Id": {
                    if (!jsonElement.getId().equals("")) {
                        selector = this.getSelector(jsonElement.getId(), valueToSet);
                        List elementsById = page.querySelectorAll(selector);
                        if (elementsById.size() != 1) return elementHandle;
                        elementHandle = (ElementHandle)elementsById.get(0);
                        this.scrollToElement(elementHandle);
                        return elementHandle;
                    }
                    System.out.println("No Id value is present in the DOM for the element");
                    return elementHandle;
                }
                case "Name": {
                    if (!jsonElement.getName().equals("")) {
                        selector = this.getSelector(jsonElement.getName(), valueToSet);
                        List elementsByName = page.querySelectorAll(selector);
                        if (elementsByName.size() != 1) return elementHandle;
                        elementHandle = (ElementHandle)elementsByName.get(0);
                        this.scrollToElement(elementHandle);
                        return elementHandle;
                    }
                    System.out.println("No Name value is present in the DOM for the element");
                    return elementHandle;
                }
                case "Xpaths": {
                    for (String xpath : jsonElement.getXpaths()) {
                        List elementsByXpath;
                        if (xpath == null || (elementsByXpath = page.querySelectorAll(selector = this.getSelector(xpath, valueToSet))).size() != 1) continue;
                        elementHandle = (ElementHandle)elementsByXpath.get(0);
                        this.scrollToElement(elementHandle);
                        return elementHandle;
                    }
                    return elementHandle;
                }
            }
            return elementHandle;
        }
        System.out.println("The JSON file does not contain information of the passed element");
        return elementHandle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Locator findPageElementByXpath(String locator, Element jsonElement, String valueToSet) {
        Locator locator1 = null;
        String selector = "";
        if (jsonElement != null) {
            switch (locator) {
                case "Id": {
                    if (!jsonElement.getId().equals("")) {
                        selector = this.getSelector(jsonElement.getId(), valueToSet);
                        Locator lacator2 = page.locator(selector);
                        if (lacator2.count() != 1) return locator1;
                        return lacator2;
                    }
                    System.out.println("No Id value is present in the DOM for the element");
                    return locator1;
                }
                case "Name": {
                    if (!jsonElement.getName().equals("")) {
                        selector = this.getSelector(jsonElement.getName(), valueToSet);
                        Locator lacator2 = page.locator(selector);
                        if (lacator2.count() != 1) return locator1;
                        return lacator2;
                    }
                    System.out.println("No Name value is present in the DOM for the element");
                    return locator1;
                }
                case "Xpaths": {
                    String[] stringArray = jsonElement.getXpaths();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Locator locator2;
                        String xpath = stringArray[n2];
                        if (xpath != null && (locator2 = page.locator(selector = this.getSelector(xpath, valueToSet))).count() == 1) {
                            return locator2;
                        }
                        ++n2;
                    }
                    return locator1;
                }
            }
            return locator1;
        } else {
            System.out.println("The JSON file does not contain information of the passed element");
        }
        return locator1;
    }

    private String getSelector(String baseSelector, String valueToSet) {
        if (baseSelector.contains("radiobuttonlabel")) {
            return baseSelector.replace("radiobuttonlabel", valueToSet);
        }
        if (baseSelector.contains("textlabel")) {
            return baseSelector.replace("textlabel", valueToSet);
        }
        if (baseSelector.contains("checkboxlabel")) {
            return baseSelector.replace("checkboxlabel", valueToSet);
        }
        return baseSelector;
    }

    public void performActionOnElement(String elementName, String currentPageName, String valueToSet) throws InterruptedException {
        if (page == null) {
            System.out.println("Browser Page is null here");
        }
        logger.info(this.getClass().getSimpleName() + "-" + currentPageName + "-" + elementName + "-" + valueToSet);
        Element elementDetails = this.getElementDetailsFromPage(elementName, currentPageName);
        switch (elementDetails.getElementType()) {
            case "Button": 
            case "Checkbox": 
            case "InputDropdownOption": 
            case "Radio": {
                this.Click(elementDetails, valueToSet);
                break;
            }
            case "TextInput": {
                this.SetValueTextBox(elementDetails, valueToSet);
                break;
            }
            case "TextInputWithEnter": {
                this.SetValueTextBoxWithEnterKey(elementDetails, valueToSet);
                break;
            }
            case "VerifyText": {
                this.pageVerification(elementDetails, valueToSet);
                break;
            }
            case "VerifyAlert": {
                this.Verify(elementDetails);
                break;
            }
            case "SelectDropdown": {
                this.SelectTextDropDown(elementDetails, valueToSet);
                break;
            }
            case "InputDropdown": {
                this.SetValue(elementDetails, valueToSet);
                break;
            }
        }
    }

    public void performPageActionOnElement(String elementName, String currentPageName, String valueToSet) throws InterruptedException {
        if (page == null) {
            System.out.println("Browser Page is null here");
        }
        logger.info(this.getClass().getSimpleName() + "-" + currentPageName + "-" + elementName + "-" + valueToSet);
        Element elementDetails = this.getElementDetailsFromPage(elementName, currentPageName);
        switch (elementDetails.getElementType()) {
            case "Button": 
            case "Checkbox": 
            case "InputDropdownOption": 
            case "Radio": {
                this.pageClick(elementDetails, valueToSet);
                break;
            }
            case "TextInput": {
                this.pageSetValueTextBox(elementDetails, valueToSet);
                break;
            }
            case "TextInputWithEnter": {
                this.pageSetValueTextBoxWithEnterKey(elementDetails, valueToSet);
            }
            case "VerifyText": {
                this.pageVerification(elementDetails, valueToSet);
                break;
            }
            case "VerifyAlert": {
                this.Verify(elementDetails);
                break;
            }
            case "SelectDropdown": {
                this.SelectTextDropDown(elementDetails, valueToSet);
                break;
            }
            case "InputDropdown": {
                this.SetValue(elementDetails, valueToSet);
                break;
            }
        }
    }

    public boolean assertionOfElement(String elementName, String currentPageName, String valueToSet) throws InterruptedException {
        if (page == null) {
            System.out.println("Browser Page is null here");
        }
        boolean flagForAssertion = false;
        logger.info(this.getClass().getSimpleName() + "-" + currentPageName + "-" + elementName + "-" + valueToSet);
        Element elementDetails = this.getElementDetailsFromPage(elementName, currentPageName);
        flagForAssertion = this.assertElementOnThePage(elementDetails, valueToSet);
        return flagForAssertion;
    }

    public void storeText(String verifyKey, String value) {
        logger.info("Storing value: " + value + " for key: " + verifyKey);
        this.temp.put(verifyKey, value);
    }

    public boolean isElementInViewPort(ElementHandle element) {
        System.out.println("Checking whether element is present on page: " + element);
        return (Boolean)page.evaluate("element => {  const box = element.getBoundingClientRect();  const cx = box.left + box.width / 2;  const cy = box.top + box.height / 2;  const e = document.elementFromPoint(cx, cy);  for (let currentElement = e; currentElement; currentElement = currentElement.parentElement) {    if (currentElement === element)      return true;  }  return false;}", (Object)element);
    }

    public void scrollToElement(ElementHandle element) {
        System.out.println("Scrolling to element: " + element);
        try {
            element.scrollIntoViewIfNeeded();
        }
        catch (PlaywrightException e) {
            System.out.println("Error scrolling into view: " + e.getMessage());
        }
    }

    public void scrollToPageByPixel(int pixels) {
        System.out.println("Scrolling page by " + pixels + " pixels");
        page.evaluate("pixels => { window.scrollBy(0, pixels); }", (Object)pixels);
    }

    public boolean verification(Element verifyValue, String verifyKey) {
        logger.info(this.getClass().getSimpleName() + "-" + verifyValue);
        try {
            if (!verifyKey.isEmpty()) {
                ElementHandle elem = this.getWebElement(verifyValue, verifyKey);
                return elem.isVisible();
            }
            ElementHandle element = this.getWebElement(verifyValue, "");
            return element.isVisible();
        }
        catch (Exception e) {
            logger.error("Verification failed for web element: " + verifyValue);
            return false;
        }
    }

    public void pageVerification(Element verifyValue, String verifyKey) {
        logger.info(this.getClass().getSimpleName() + "-" + verifyValue);
        if (!verifyKey.isEmpty()) {
            Locator elem = this.pageGetWebElement(verifyValue, verifyKey);
            Assert.assertTrue((boolean)elem.isVisible(), (String)("Verification failed for web element: " + verifyValue));
        } else {
            Locator elem = this.pageGetWebElement(verifyValue, verifyKey);
            Assert.assertTrue((boolean)elem.isVisible(), (String)("Verification failed for web element: " + verifyValue));
        }
    }

    public boolean assertElementOnThePage(Element verifyValue, String verifyKey) {
        Logger var10000 = logger;
        String var10001 = this.getClass().getSimpleName();
        var10000.info(var10001 + "-" + verifyValue);
        try {
            if (!verifyKey.isEmpty()) {
                Locator elem = this.pageGetWebElement(verifyValue, verifyKey);
                return elem.isVisible();
            }
            Locator elem = this.pageGetWebElement(verifyValue, verifyKey);
            return elem.isVisible();
        }
        catch (Exception var4) {
            logger.error("Verification failed for web element : " + verifyValue);
            return false;
        }
    }

    private void Click(Element ElementLocator, String valueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementLocator);
        ElementHandle Elem = this.getWebElement(ElementLocator, valueToSet);
        Elem.click();
    }

    private void pageClick(Element ElementLocator, String valueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementLocator);
        Locator Elem = this.pageGetWebElement(ElementLocator, valueToSet);
        Elem.click();
    }

    private void SetValue(Element ElementDetails, String ValueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementDetails + "-" + ValueToSet);
        if (ValueToSet == null) {
            return;
        }
        ElementHandle element = this.getWebElement(ElementDetails, ValueToSet);
        if (element.isEnabled()) {
            element.click();
            element.focus();
            page.keyboard().press("Control+A");
            page.keyboard().press("Backspace");
            Thread.sleep(2000L);
            element.fill(ValueToSet);
            page.keyboard().press("Enter");
        }
    }

    private void SetValueTextBox(Element ElementDetails, String ValueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementDetails + "-" + ValueToSet);
        if (ValueToSet == null) {
            return;
        }
        ElementHandle element = this.getWebElement(ElementDetails, ValueToSet);
        if (element.isEditable()) {
            Thread.sleep(1000L);
            element.fill(ValueToSet);
        }
    }

    private void pageSetValueTextBox(Element ElementDetails, String ValueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementDetails + "-" + ValueToSet);
        if (ValueToSet == null) {
            return;
        }
        Locator element = this.pageGetWebElement(ElementDetails, ValueToSet);
        if (element.isEditable()) {
            Thread.sleep(1000L);
            element.clear();
            element.fill(ValueToSet);
        }
    }

    private void pageValueTextBoxWithEnterKey(Element ElementDetails, String ValueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementDetails + "-" + ValueToSet);
        if (ValueToSet == null) {
            return;
        }
        ElementHandle element = this.getWebElement(ElementDetails, ValueToSet);
        if (element.isEditable()) {
            Thread.sleep(1000L);
            element.fill(ValueToSet);
            page.keyboard().press("Enter");
        }
    }

    private void pageSetValueTextBoxWithEnterKey(Element ElementDetails, String ValueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementDetails + "-" + ValueToSet);
        if (ValueToSet == null) {
            return;
        }
        Locator element = this.pageGetWebElement(ElementDetails, ValueToSet);
        if (element.isEditable()) {
            Thread.sleep(1000L);
            element.fill(ValueToSet);
            page.keyboard().press("Enter");
        }
    }

    private void SetValueTextBoxWithEnterKey(Element ElementDetails, String ValueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementDetails + "-" + ValueToSet);
        if (ValueToSet == null) {
            return;
        }
        ElementHandle element = this.getWebElement(ElementDetails, ValueToSet);
        if (element.isEditable()) {
            Thread.sleep(1000L);
            element.fill(ValueToSet);
            page.keyboard().press("Enter");
        }
    }

    private boolean Verify(Element ElementName) {
        ElementHandle element = this.getWebElement(ElementName, "");
        try {
            return element.isVisible();
        }
        catch (Exception e) {
            logger.error("Verification failed for web element: " + ElementName);
            return false;
        }
    }

    private void SelectDropDown(Element ElementName, String DropDownOptoin) {
        ElementHandle element = this.getWebElement(ElementName, "");
        if (element.isEnabled()) {
            element.click();
            try {
                element.selectOption(DropDownOptoin);
            }
            catch (PlaywrightException e) {
                element.selectOption(new SelectOption().setLabel(DropDownOptoin));
            }
        }
    }

    private void SelectTextDropDown(Element ElementName, String DropDownOption) {
        ElementHandle element = this.getWebElement(ElementName, "");
        if (element.isEnabled()) {
            try {
                element.fill(DropDownOption);
                page.keyboard().press("Enter");
            }
            catch (PlaywrightException e) {
                element.selectOption(new SelectOption().setLabel(DropDownOption));
            }
        }
    }

    public boolean VerifySelected(String ElementName, String currentPageName) {
        Element elementDetails = this.getElementDetailsFromPage(ElementName, currentPageName);
        ElementHandle element = this.getWebElement(elementDetails, "");
        try {
            return element.isChecked();
        }
        catch (PlaywrightException e) {
            System.err.println("The element is not selected: " + ElementName);
            return false;
        }
    }

    public static <T> List<T> takeScreenShots() throws IOException {
        long millisStart = Calendar.getInstance().getTimeInMillis();
        Page.ScreenshotOptions options = new Page.ScreenshotOptions();
        options.setType(ScreenshotType.JPEG);
        options.setPath(Paths.get("src/test/resources/Screenshots/Embedded-" + count + ".png", new String[0]));
        options.setQuality(100);
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        double width = size.getWidth();
        double height = size.getHeight();
        options.setClip(width - (width - 1.0), height - (height - 1.0), width, height);
        array = page.screenshot(options);
        page.screenshot();
        ArrayList<Object> output = new ArrayList<Object>();
        output.add(array);
        StringBuilder embedded = new StringBuilder();
        embedded.append("Embedded").append("-").append(count).append(".png");
        output.add(embedded);
        ++count;
        return output;
    }

    public <T> void takeScreenshot() throws Exception {
        List<T> output = BasePage.takeScreenShots();
        scenario.attach(array, "image/png", String.valueOf(output.get(1)));
    }

    public boolean checkingForTheElementOnThePage(String elementName, String currentPageName, String valueToSet) throws InterruptedException {
        if (page == null) {
            System.out.println("Browser Page is null here");
        }
        logger.info(this.getClass().getSimpleName() + "-" + currentPageName + "-" + elementName + "-" + valueToSet);
        Element elementDetails = this.getElementDetailsFromPage(elementName, currentPageName);
        logger.info(this.getClass().getSimpleName() + "-" + elementDetails);
        ElementHandle Elem = this.getWebElement(elementDetails, valueToSet);
        return Elem != null;
    }

    public void ReportClick(Element ElementLocator, String valueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementLocator);
        ElementHandle Elem = this.getReportLinkWebElement(ElementLocator, valueToSet);
        Elem.click();
    }

    public ElementHandle getReportLinkWebElement(Element jsonElement, String valueToSet) throws InterruptedException {
        List<String> locator = List.of("Xpaths");
        ElementHandle elementHandle = null;
        for (String by : locator) {
            Thread.sleep(2000L);
            ElementHandle element = this.findElementByXpathForReportLink(by, jsonElement, valueToSet);
            if (element == null) continue;
            elementHandle = element;
            break;
        }
        return elementHandle;
    }

    public ElementHandle findElementByXpathForReportLink(String locator, Element jsonElement, String valueToSet) {
        ElementHandle elementHandle = null;
        String selector = "";
        if (jsonElement != null) {
            for (String xpath : jsonElement.getXpaths()) {
                if (xpath == null) continue;
                selector = this.getSelector(xpath, valueToSet);
                page.waitForSelector(selector, new Page.WaitForSelectorOptions().setState(WaitForSelectorState.VISIBLE));
                List elementsByXpath = page.querySelectorAll(selector);
                if (elementsByXpath.size() != 1) continue;
                elementHandle = (ElementHandle)elementsByXpath.get(0);
                this.scrollToElement(elementHandle);
                break;
            }
        }
        return elementHandle;
    }

    static {
        count = 0;
    }
}

