/*
 * Decompiled with CFR 0.152.
 */
package org.SpurQLabs.Utilities;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONObject;

public class CommonUtil {
    private static String filePath;
    private static String sheetName;

    public static void setFilePathAndSheetName(String filePath1, String sheetName1) {
        filePath = filePath1;
        sheetName = sheetName1;
    }

    public static String getDateTimeTicks() {
        long time = System.currentTimeMillis();
        return String.valueOf(time);
    }

    public static String getFrameworkConfig(String parameter) {
        String assemblyLocation = System.getProperty("user.dir");
        String path = Paths.get(assemblyLocation + "/FrameworkConfig.json", new String[0]).toString();
        String fullPath = new File(path).getAbsolutePath();
        try {
            String json = Files.readString(Path.of(fullPath, new String[0]));
            JSONObject jObject = new JSONObject(json);
            return jObject.optString(parameter, "");
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getTimezone() {
        TimeZone zone = TimeZone.getDefault();
        return zone.getID();
    }

    public static String getTimestamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        return sdf.format(new Date());
    }

    public static String getFilename(String name) {
        return name + "_" + CommonUtil.getDateTimeTicks() + ".png";
    }

    public static String getLatestFileFromDir(String dirPath) {
        try {
            File[] files = new File(dirPath).listFiles();
            if (files != null && files.length > 0) {
                File latestFile = Arrays.stream(files).max(Comparator.comparingLong(File::lastModified)).orElseThrow(() -> new RuntimeException("No files found in the directory"));
                return latestFile.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getCurrentPSTDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("MMMM d, yyyy");
        sdf.setTimeZone(TimeZone.getTimeZone("America/Los_Angeles"));
        return sdf.format(new Date());
    }

    public static String createFileName() throws IOException {
        long millisStart = Calendar.getInstance().getTimeInMillis();
        String folder = CommonUtil.getFrameworkConfig("TestResultsDir");
        Path path = Paths.get(folder, new String[0]);
        Files.createDirectories(path, new FileAttribute[0]);
        return millisStart + ".png";
    }
}

