/*
 * Decompiled with CFR 0.152.
 */
package org.SpurQLabs.Core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.ElementHandle;
import com.microsoft.playwright.Locator;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.options.MouseButton;
import com.microsoft.playwright.options.ScreenshotType;
import com.microsoft.playwright.options.SelectOption;
import com.microsoft.playwright.options.WaitForSelectorState;
import io.cucumber.java.Scenario;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.SpurQLabs.Core.Element;
import org.SpurQLabs.Core.JsonPage;
import org.SpurQLabs.Utilities.CommonUtil;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.testng.Assert;

public class BasePage {
    public static Page page;
    public static Logger logger;
    protected Gson gson;
    protected HashMap<String, String> temp;
    public static byte[] array;
    public static int count;
    public static Scenario scenario;
    private String BasePageDestinationPath;
    private static List<String> pdfData;

    public BasePage(Page page, Logger logger, Scenario scenario1) {
        BasePage.page = page;
        BasePage.logger = logger;
        this.gson = new GsonBuilder().create();
        this.temp = new HashMap();
        scenario = scenario1;
    }

    public JsonPage createPage(String filePath) {
        try {
            String jsonContent = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
            return (JsonPage)this.gson.fromJson(jsonContent, JsonPage.class);
        }
        catch (IOException e) {
            logger.warn("Error reading JSON file: {}", (Object)e.getMessage());
            return null;
        }
    }

    public JsonPage getPage(String pageName) {
        try {
            String jsonFilePath = CommonUtil.getFrameworkConfig("JsonFilePath") + pageName + ".json";
            String jsonContent = new String(Files.readAllBytes(Paths.get(jsonFilePath, new String[0])));
            return (JsonPage)this.gson.fromJson(jsonContent, JsonPage.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid page or Invalid JSON file", e);
        }
    }

    public String getElementFromPage(String key, String pageName) {
        try {
            Element element;
            List<String> xpaths;
            Optional<Element> elementOptional;
            JsonPage page = this.getPage(pageName);
            if (page != null && page.getElements() != null && (elementOptional = page.getElements().stream().filter(e -> key.equals(e.getElementName())).findFirst()).isPresent() && !(xpaths = List.of((element = elementOptional.get()).getXpaths())).isEmpty()) {
                return xpaths.get(0);
            }
            return null;
        }
        catch (Exception ex) {
            logger.warn("Error getting element from page: {}" + ex.getMessage());
            return null;
        }
    }

    private String getElementName(String key, String pageName) {
        Element element = this.getElementDetailsFromPage(key, pageName);
        return element != null ? element.getElementName() : "";
    }

    public Element getElementDetailsFromPage(String elementName, String pageName) {
        try {
            JsonPage page = this.getPage(pageName);
            if (page != null) {
                Optional<Element> elementOptional = page.getElements().stream().filter(e -> elementName.equals(e.getElementName())).findFirst();
                return elementOptional.orElse(null);
            }
            return null;
        }
        catch (Exception ex) {
            logger.warn("Error getting element details from page: {}", (Object)ex.getMessage());
            return null;
        }
    }

    public ElementHandle getWebElement(Element jsonElement, String valueToSet) {
        List<String> locator = List.of("Xpaths", "Id", "Name");
        ElementHandle elementHandle = null;
        for (String by : locator) {
            ElementHandle element = this.findElementByXpath(by, jsonElement, valueToSet);
            if (element == null) continue;
            elementHandle = element;
            break;
        }
        return elementHandle;
    }

    public Locator pageGetWebElement(Element jsonElement, String valueToSet) {
        List<String> locator = List.of("Xpaths", "Id", "Name");
        Object elementHandle = null;
        Locator locator1 = null;
        for (String by : locator) {
            Locator element = this.findPageElementByXpath(by, jsonElement, valueToSet);
            if (element == null) continue;
            locator1 = element;
            break;
        }
        return locator1;
    }

    private List<ElementHandle> waitForElements(String selector) {
        int timeout = Integer.parseInt(CommonUtil.getFrameworkConfig("Explicit_WAIT"));
        page.waitForSelector(selector, new Page.WaitForSelectorOptions().setState(WaitForSelectorState.ATTACHED).setTimeout((double)timeout));
        return page.querySelectorAll(selector);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ElementHandle findElementByXpath(String locator, Element jsonElement, String valueToSet) {
        ElementHandle elementHandle = null;
        String selector = "";
        if (jsonElement != null) {
            switch (locator) {
                case "Id": {
                    if (!jsonElement.getId().equals("")) {
                        selector = this.getSelector(jsonElement.getId(), valueToSet);
                        List<ElementHandle> elementsById = this.waitForElements(selector);
                        if (elementsById.size() != 1) return elementHandle;
                        elementHandle = elementsById.get(0);
                        this.scrollToElement(elementHandle);
                        return elementHandle;
                    }
                    System.out.println("No Id value is present in the DOM for the element");
                    return elementHandle;
                }
                case "Name": {
                    if (!jsonElement.getName().equals("")) {
                        selector = this.getSelector(jsonElement.getName(), valueToSet);
                        List<ElementHandle> elementsByName = this.waitForElements(selector);
                        if (elementsByName.size() != 1) return elementHandle;
                        elementHandle = elementsByName.get(0);
                        this.scrollToElement(elementHandle);
                        return elementHandle;
                    }
                    System.out.println("No Name value is present in the DOM for the element");
                    return elementHandle;
                }
                case "Xpaths": {
                    for (String xpath : jsonElement.getXpaths()) {
                        List<ElementHandle> elementsByXpath;
                        if (xpath == null || (elementsByXpath = this.waitForElements(selector = this.getSelector(xpath, valueToSet))).size() != 1) continue;
                        elementHandle = elementsByXpath.get(0);
                        this.scrollToElement(elementHandle);
                        return elementHandle;
                    }
                    return elementHandle;
                }
            }
            return elementHandle;
        }
        System.out.println("The JSON file does not contain information of the passed element");
        return elementHandle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Locator findPageElementByXpath(String locator, Element jsonElement, String valueToSet) {
        Locator locator1 = null;
        String selector = "";
        if (jsonElement != null) {
            switch (locator) {
                case "Id": {
                    if (!jsonElement.getId().equals("")) {
                        selector = this.getSelector(jsonElement.getId(), valueToSet);
                        Locator lacator2 = page.locator(selector);
                        if (lacator2.count() != 1) return locator1;
                        return lacator2;
                    }
                    System.out.println("No Id value is present in the DOM for the element");
                    return locator1;
                }
                case "Name": {
                    if (!jsonElement.getName().equals("")) {
                        selector = this.getSelector(jsonElement.getName(), valueToSet);
                        Locator lacator2 = page.locator(selector);
                        if (lacator2.count() != 1) return locator1;
                        return lacator2;
                    }
                    System.out.println("No Name value is present in the DOM for the element");
                    return locator1;
                }
                case "Xpaths": {
                    String[] stringArray = jsonElement.getXpaths();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Locator locator2;
                        String xpath = stringArray[n2];
                        if (xpath != null && (locator2 = page.locator(selector = this.getSelector(xpath, valueToSet))).count() == 1) {
                            return locator2;
                        }
                        ++n2;
                    }
                    return locator1;
                }
            }
            return locator1;
        } else {
            System.out.println("The JSON file does not contain information of the passed element");
        }
        return locator1;
    }

    private String getSelector(String baseSelector, String valueToSet) {
        if (baseSelector.contains("radiobuttonlabel")) {
            return baseSelector.replace("radiobuttonlabel", valueToSet);
        }
        if (baseSelector.contains("textlabel")) {
            return baseSelector.replace("textlabel", valueToSet);
        }
        if (baseSelector.contains("checkboxlabel")) {
            return baseSelector.replace("checkboxlabel", valueToSet);
        }
        return baseSelector;
    }

    public void performActionOnElement(String elementName, String currentPageName, String valueToSet) throws InterruptedException {
        if (page == null) {
            System.out.println("Browser Page is null here");
        }
        logger.info(this.getClass().getSimpleName() + "-" + currentPageName + "-" + elementName + "-" + valueToSet);
        Element elementDetails = this.getElementDetailsFromPage(elementName, currentPageName);
        switch (elementDetails.getElementType()) {
            case "Button": 
            case "Checkbox": 
            case "InputDropdownOption": 
            case "Radio": {
                this.Click(elementDetails, valueToSet);
                break;
            }
            case "TextInput": {
                this.SetValueTextBox(elementDetails, valueToSet);
                break;
            }
            case "TextInputWithEnter": {
                this.SetValueTextBoxWithEnterKey(elementDetails, valueToSet);
                break;
            }
            case "FirstClickTheBoxThenEnterTextAndEnter": {
                this.FirstClickAndThenEnterTextBoxWithEnterKey(elementDetails, valueToSet);
                break;
            }
            case "VerifyText": {
                this.pageVerification(elementDetails, valueToSet);
                break;
            }
            case "VerifyAlert": {
                this.Verify(elementDetails);
                break;
            }
            case "SelectDropdown": {
                this.SelectTextDropDown(elementDetails, valueToSet);
                break;
            }
            case "InputDropdown": {
                this.SetValue(elementDetails, valueToSet);
                break;
            }
            case "DoubleClick": {
                this.doubleClick(elementDetails, valueToSet);
                break;
            }
            case "RightClick": {
                this.RightClick(elementDetails, valueToSet);
                break;
            }
            case "DoubleClickAndEnter": {
                this.DoubleClickAndEnter(elementDetails, valueToSet);
                break;
            }
            case "ClickAndEnter": {
                this.clickAndEnter(elementDetails, valueToSet);
                break;
            }
        }
    }

    public void performPageActionOnElement(String elementName, String currentPageName, String valueToSet) throws InterruptedException {
        if (page == null) {
            System.out.println("Browser Page is null here");
        }
        logger.info(this.getClass().getSimpleName() + "-" + currentPageName + "-" + elementName + "-" + valueToSet);
        Element elementDetails = this.getElementDetailsFromPage(elementName, currentPageName);
        switch (elementDetails.getElementType()) {
            case "Button": 
            case "Checkbox": 
            case "InputDropdownOption": 
            case "Radio": {
                this.pageClick(elementDetails, valueToSet);
                break;
            }
            case "TextInput": {
                this.pageSetValueTextBox(elementDetails, valueToSet);
                break;
            }
            case "TextInputWithEnter": {
                this.pageSetValueTextBoxWithEnterKey(elementDetails, valueToSet);
            }
            case "VerifyText": {
                this.pageVerification(elementDetails, valueToSet);
                break;
            }
            case "VerifyAlert": {
                this.Verify(elementDetails);
                break;
            }
            case "SelectDropdown": {
                this.SelectTextDropDown(elementDetails, valueToSet);
                break;
            }
            case "InputDropdown": {
                this.SetValue(elementDetails, valueToSet);
                break;
            }
        }
    }

    public boolean assertionOfElement(String elementName, String currentPageName, String valueToSet) throws InterruptedException {
        if (page == null) {
            System.out.println("Browser Page is null here");
        }
        boolean flagForAssertion = false;
        logger.info(this.getClass().getSimpleName() + "-" + currentPageName + "-" + elementName + "-" + valueToSet);
        Element elementDetails = this.getElementDetailsFromPage(elementName, currentPageName);
        flagForAssertion = this.assertElementOnThePage(elementDetails, valueToSet);
        return flagForAssertion;
    }

    public void storeText(String verifyKey, String value) {
        logger.info("Storing value: " + value + " for key: " + verifyKey);
        this.temp.put(verifyKey, value);
    }

    public boolean isElementInViewPort(ElementHandle element) {
        System.out.println("Checking whether element is present on page: " + element);
        return (Boolean)page.evaluate("element => {  const box = element.getBoundingClientRect();  const cx = box.left + box.width / 2;  const cy = box.top + box.height / 2;  const e = document.elementFromPoint(cx, cy);  for (let currentElement = e; currentElement; currentElement = currentElement.parentElement) {    if (currentElement === element)      return true;  }  return false;}", (Object)element);
    }

    public void scrollToElement(ElementHandle element) {
        System.out.println("Scrolling to element: " + element);
        try {
            element.scrollIntoViewIfNeeded();
        }
        catch (PlaywrightException e) {
            System.out.println("Error scrolling into view: " + e.getMessage());
        }
    }

    public void scrollToPageByPixel(int pixels) {
        System.out.println("Scrolling page by " + pixels + " pixels");
        page.evaluate("pixels => { window.scrollBy(0, pixels); }", (Object)pixels);
    }

    public boolean verification(Element verifyValue, String verifyKey) {
        logger.info(this.getClass().getSimpleName() + "-" + verifyValue);
        try {
            if (!verifyKey.isEmpty()) {
                ElementHandle elem = this.getWebElement(verifyValue, verifyKey);
                return elem.isVisible();
            }
            ElementHandle element = this.getWebElement(verifyValue, "");
            return element.isVisible();
        }
        catch (Exception e) {
            logger.error("Verification failed for web element: " + verifyValue);
            return false;
        }
    }

    public void pageVerification(Element verifyValue, String verifyKey) {
        logger.info(this.getClass().getSimpleName() + "-" + verifyValue);
        if (!verifyKey.isEmpty()) {
            Locator elem = this.pageGetWebElement(verifyValue, verifyKey);
            Assert.assertTrue((boolean)elem.isVisible(), (String)("Verification failed for web element: " + verifyValue));
        } else {
            Locator elem = this.pageGetWebElement(verifyValue, verifyKey);
            Assert.assertTrue((boolean)elem.isVisible(), (String)("Verification failed for web element: " + verifyValue));
        }
    }

    public boolean assertElementOnThePage(Element verifyValue, String verifyKey) {
        Logger var10000 = logger;
        String var10001 = this.getClass().getSimpleName();
        var10000.info(var10001 + "-" + verifyValue);
        try {
            if (!verifyKey.isEmpty()) {
                Locator elem = this.pageGetWebElement(verifyValue, verifyKey);
                return elem.isVisible();
            }
            Locator elem = this.pageGetWebElement(verifyValue, verifyKey);
            return elem.isVisible();
        }
        catch (Exception var4) {
            logger.error("Verification failed for web element : " + verifyValue);
            return false;
        }
    }

    private void Click(Element ElementLocator, String valueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementLocator);
        ElementHandle Elem = this.getWebElement(ElementLocator, valueToSet);
        Elem.click();
    }

    private void pageClick(Element ElementLocator, String valueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementLocator);
        Locator Elem = this.pageGetWebElement(ElementLocator, valueToSet);
        Elem.click();
    }

    private void SetValue(Element ElementDetails, String ValueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementDetails + "-" + ValueToSet);
        if (ValueToSet == null) {
            return;
        }
        ElementHandle element = this.getWebElement(ElementDetails, ValueToSet);
        if (element.isEnabled()) {
            element.click();
            element.focus();
            page.keyboard().press("Control+A");
            page.keyboard().press("Backspace");
            Thread.sleep(2000L);
            element.fill(ValueToSet);
            page.keyboard().press("Enter");
        }
    }

    private void SetValueTextBox(Element ElementDetails, String ValueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementDetails + "-" + ValueToSet);
        if (ValueToSet == null) {
            return;
        }
        ElementHandle element = this.getWebElement(ElementDetails, ValueToSet);
        if (element.isEditable()) {
            Thread.sleep(1000L);
            element.fill(ValueToSet);
        }
    }

    private void pageSetValueTextBox(Element ElementDetails, String ValueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementDetails + "-" + ValueToSet);
        if (ValueToSet == null) {
            return;
        }
        Locator element = this.pageGetWebElement(ElementDetails, ValueToSet);
        if (element.isEditable()) {
            Thread.sleep(1000L);
            element.clear();
            element.fill(ValueToSet);
        }
    }

    private void pageValueTextBoxWithEnterKey(Element ElementDetails, String ValueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementDetails + "-" + ValueToSet);
        if (ValueToSet == null) {
            return;
        }
        ElementHandle element = this.getWebElement(ElementDetails, ValueToSet);
        if (element.isEditable()) {
            Thread.sleep(1000L);
            element.fill(ValueToSet);
            page.keyboard().press("Enter");
        }
    }

    private void pageSetValueTextBoxWithEnterKey(Element ElementDetails, String ValueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementDetails + "-" + ValueToSet);
        if (ValueToSet == null) {
            return;
        }
        Locator element = this.pageGetWebElement(ElementDetails, ValueToSet);
        if (element.isEditable()) {
            Thread.sleep(1000L);
            element.fill(ValueToSet);
            page.keyboard().press("Enter");
        }
    }

    private void SetValueTextBoxWithEnterKey(Element ElementDetails, String ValueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementDetails + "-" + ValueToSet);
        if (ValueToSet == null) {
            return;
        }
        ElementHandle element = this.getWebElement(ElementDetails, ValueToSet);
        if (element.isEditable()) {
            Thread.sleep(1000L);
            element.fill(ValueToSet);
            page.keyboard().press("Enter");
        }
    }

    private boolean Verify(Element ElementName) {
        ElementHandle element = this.getWebElement(ElementName, "");
        try {
            return element.isVisible();
        }
        catch (Exception e) {
            logger.error("Verification failed for web element: " + ElementName);
            return false;
        }
    }

    private void SelectDropDown(Element ElementName, String DropDownOptoin) {
        ElementHandle element = this.getWebElement(ElementName, "");
        if (element.isEnabled()) {
            element.click();
            try {
                element.selectOption(DropDownOptoin);
            }
            catch (PlaywrightException e) {
                element.selectOption(new SelectOption().setLabel(DropDownOptoin));
            }
        }
    }

    private void SelectTextDropDown(Element ElementName, String DropDownOption) {
        ElementHandle element = this.getWebElement(ElementName, "");
        if (element.isEnabled()) {
            try {
                element.fill(DropDownOption);
                page.keyboard().press("Enter");
            }
            catch (PlaywrightException e) {
                element.selectOption(new SelectOption().setLabel(DropDownOption));
            }
        }
    }

    public boolean VerifySelected(String ElementName, String currentPageName) {
        Element elementDetails = this.getElementDetailsFromPage(ElementName, currentPageName);
        ElementHandle element = this.getWebElement(elementDetails, "");
        try {
            return element.isChecked();
        }
        catch (PlaywrightException e) {
            System.err.println("The element is not selected: " + ElementName);
            return false;
        }
    }

    public static <T> List<T> takeScreenShots() throws IOException {
        long millisStart = Calendar.getInstance().getTimeInMillis();
        Page.ScreenshotOptions options = new Page.ScreenshotOptions();
        options.setType(ScreenshotType.JPEG);
        options.setPath(Paths.get("src/test/resources/Screenshots/Embedded-" + count + ".png", new String[0]));
        options.setQuality(100);
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        double width = size.getWidth();
        double height = size.getHeight();
        options.setClip(width - (width - 1.0), height - (height - 1.0), width, height);
        array = page.screenshot(options);
        page.screenshot();
        ArrayList<Object> output = new ArrayList<Object>();
        output.add(array);
        StringBuilder embedded = new StringBuilder();
        embedded.append("Embedded").append("-").append(count).append(".png");
        output.add(embedded);
        ++count;
        return output;
    }

    public <T> void takeScreenshot() throws Exception {
        List<T> output = BasePage.takeScreenShots();
        scenario.attach(array, "image/png", String.valueOf(output.get(1)));
    }

    public boolean checkingForTheElementOnThePage(String elementName, String currentPageName, String valueToSet) throws InterruptedException {
        if (page == null) {
            System.out.println("Browser Page is null here");
        }
        logger.info(this.getClass().getSimpleName() + "-" + currentPageName + "-" + elementName + "-" + valueToSet);
        Element elementDetails = this.getElementDetailsFromPage(elementName, currentPageName);
        logger.info(this.getClass().getSimpleName() + "-" + elementDetails);
        ElementHandle Elem = this.getWebElement(elementDetails, valueToSet);
        return Elem != null;
    }

    private void clickAndEnter(Element ElementLocator, String valueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementLocator);
        ElementHandle Elem = this.getWebElement(ElementLocator, valueToSet);
        if (Elem.isEditable()) {
            Elem.click();
            page.keyboard().press("Enter");
        }
    }

    private void doubleClick(Element ElementLocator, String valueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementLocator);
        ElementHandle Elem = this.getWebElement(ElementLocator, valueToSet);
        Elem.dblclick();
    }

    public String readInnerTextOfLocator(String elementName, String currentPageName, String valueToSet) throws InterruptedException {
        String innerTextOfLocator = "";
        logger.info(this.getClass().getSimpleName() + "-" + currentPageName + "-" + elementName + "-" + valueToSet);
        Element elementDetails = this.getElementDetailsFromPage(elementName, currentPageName);
        logger.info(this.getClass().getSimpleName() + "-" + elementDetails);
        ElementHandle Elem = this.getWebElement(elementDetails, valueToSet);
        if (Elem.isEditable()) {
            innerTextOfLocator = Elem.innerText();
        }
        return innerTextOfLocator;
    }

    private void DoubleClickAndEnter(Element ElementLocator, String valueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementLocator);
        ElementHandle Elem = this.getWebElement(ElementLocator, valueToSet);
        if (Elem.isEditable()) {
            Elem.click();
            Elem.click();
            page.keyboard().press("Enter");
        }
    }

    private void RightClick(Element ElementLocator, String valueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementLocator);
        ElementHandle Elem = this.getWebElement(ElementLocator, valueToSet);
        Elem.click(new ElementHandle.ClickOptions().setButton(MouseButton.RIGHT).setForce(true));
    }

    public void SetTwoValueTextBox(String elementName, String currentPageName, String ValueToSet, String ValueToEnter) throws InterruptedException {
        Element ElementDetails = this.getElementDetailsFromPage(elementName, currentPageName);
        logger.info(this.getClass().getSimpleName() + "-" + ElementDetails + "-" + ValueToSet);
        ElementHandle element = this.getWebElement(ElementDetails, ValueToSet);
        if (element.isEditable()) {
            element.click();
            Thread.sleep(1000L);
            element.fill(ValueToEnter);
            page.keyboard().press("Enter");
        }
    }

    public void EnterValueTextBoxBySendKey(String elementName, String currentPageName, String ValueToSet, String ValueToEnter) throws InterruptedException {
        Element ElementDetails = this.getElementDetailsFromPage(elementName, currentPageName);
        logger.info(this.getClass().getSimpleName() + "-" + ElementDetails + "-" + ValueToSet);
        ElementHandle element = this.getWebElement(ElementDetails, ValueToSet);
        if (element.isEditable()) {
            element.click();
            Thread.sleep(1000L);
            page.keyboard().press(ValueToEnter);
            page.keyboard().press("Enter");
        }
    }

    private void FirstClickAndThenEnterTextBoxWithEnterKey(Element ElementDetails, String ValueToSet) throws InterruptedException {
        logger.info(this.getClass().getSimpleName() + "-" + ElementDetails + "-" + ValueToSet);
        if (ValueToSet == null) {
            return;
        }
        ElementHandle element = this.getWebElement(ElementDetails, ValueToSet);
        if (element.isEditable()) {
            element.click();
            Thread.sleep(1000L);
            element.fill(ValueToSet);
            page.keyboard().press("Enter");
        }
    }

    public static byte[] takePdfFile(String filePath) throws IOException {
        File file = new File(filePath);
        byte[] bytes = Files.readAllBytes(file.toPath());
        return bytes;
    }

    public void saveReport(Page page, BrowserContext browserContext, String reportName) throws Exception {
        String destinationPath;
        Thread.sleep(1000L);
        page.reload();
        Page page0 = null;
        for (Page page_ : browserContext.pages()) {
            System.out.println(page_.url());
            if (page_.url().contains("session-start-up")) {
                page = page_;
                continue;
            }
            if (!page_.url().contains("report")) continue;
            page0 = page_;
        }
        while (!page0.locator("//span[contains(text(), \"100% Completed\")]").isVisible()) {
            Thread.sleep(1000L);
        }
        page0.locator("(//a[@id=\"downloadFile\"])[1]").click();
        Thread.sleep(7000L);
        this.BasePageDestinationPath = destinationPath = this.downloadReport(reportName);
        this.BasePageDestinationPath = destinationPath = this.downloadReportTryAgain(reportName);
        scenario.attach(BasePage.takePdfFile(destinationPath), "pdf", reportName);
    }

    public String downloadReport(String reportName) throws InterruptedException, AWTException, IOException {
        int i;
        Robot robot = new Robot();
        robot.keyPress(17);
        robot.keyPress(80);
        Thread.sleep(1000L);
        robot.keyRelease(17);
        robot.keyRelease(80);
        Thread.sleep(1000L);
        for (i = 0; i < 5; ++i) {
            robot.keyPress(9);
            Thread.sleep(1000L);
            robot.keyRelease(9);
            Thread.sleep(1000L);
        }
        Thread.sleep(1000L);
        robot.keyPress(77);
        Thread.sleep(1000L);
        robot.keyRelease(77);
        Thread.sleep(1000L);
        robot.keyPress(83);
        Thread.sleep(1000L);
        robot.keyRelease(83);
        Thread.sleep(1000L);
        for (i = 0; i < 3; ++i) {
            robot.keyPress(9);
            Thread.sleep(1000L);
            robot.keyRelease(9);
            Thread.sleep(1000L);
        }
        robot.keyPress(10);
        Thread.sleep(1000L);
        robot.keyRelease(10);
        Thread.sleep(1000L);
        Thread.sleep(4000L);
        robot.keyPress(18);
        robot.keyPress(78);
        robot.keyRelease(18);
        robot.keyRelease(78);
        robot.keyPress(17);
        robot.keyPress(65);
        robot.keyRelease(17);
        robot.keyRelease(65);
        robot.keyPress(8);
        robot.keyRelease(8);
        Object destinationPath = CommonUtil.getFrameworkConfig("ReportPath");
        System.out.println("destinationPath1 :" + (String)destinationPath);
        File file = new File((String)destinationPath);
        destinationPath = file.getAbsolutePath();
        destinationPath = (String)destinationPath + "\\" + reportName + ".pdf";
        System.out.println("Destination Path2 :" + (String)destinationPath);
        StringSelection s = new StringSelection((String)destinationPath);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s, null);
        Thread.sleep(5000L);
        robot.keyPress(17);
        robot.keyPress(86);
        Thread.sleep(1000L);
        robot.keyRelease(17);
        robot.keyRelease(86);
        robot.keyPress(18);
        robot.keyPress(83);
        robot.keyRelease(18);
        robot.keyRelease(83);
        robot.keyPress(18);
        robot.keyPress(89);
        robot.keyRelease(18);
        robot.keyRelease(89);
        Thread.sleep(5000L);
        return destinationPath;
    }

    public String downloadReportTryAgain(String reportName) throws InterruptedException, AWTException, IOException {
        int i;
        Robot robot = new Robot();
        robot.keyPress(27);
        Thread.sleep(1000L);
        robot.keyRelease(27);
        Thread.sleep(1000L);
        robot.keyPress(27);
        Thread.sleep(1000L);
        robot.keyRelease(27);
        Thread.sleep(1000L);
        robot.keyPress(27);
        Thread.sleep(1000L);
        robot.keyRelease(27);
        Thread.sleep(1000L);
        robot.keyPress(27);
        Thread.sleep(1000L);
        robot.keyRelease(27);
        Thread.sleep(1000L);
        robot.keyPress(17);
        robot.keyPress(80);
        Thread.sleep(1000L);
        robot.keyRelease(17);
        robot.keyRelease(80);
        Thread.sleep(1000L);
        for (i = 0; i < 5; ++i) {
            robot.keyPress(9);
            Thread.sleep(1000L);
            robot.keyRelease(9);
            Thread.sleep(1000L);
        }
        for (i = 0; i < 3; ++i) {
            robot.keyPress(9);
            Thread.sleep(1000L);
            robot.keyRelease(9);
            Thread.sleep(1000L);
        }
        Thread.sleep(1000L);
        robot.keyPress(10);
        Thread.sleep(1000L);
        robot.keyRelease(10);
        Thread.sleep(1000L);
        Thread.sleep(4000L);
        robot.keyPress(18);
        robot.keyPress(78);
        robot.keyRelease(18);
        robot.keyRelease(78);
        robot.keyPress(17);
        robot.keyPress(65);
        robot.keyRelease(17);
        robot.keyRelease(65);
        robot.keyPress(8);
        robot.keyRelease(8);
        Object destinationPath = CommonUtil.getFrameworkConfig("ReportPath");
        System.out.println("destinationPath1 :" + (String)destinationPath);
        File file = new File((String)destinationPath);
        destinationPath = file.getAbsolutePath();
        destinationPath = (String)destinationPath + "\\" + reportName + ".pdf";
        System.out.println("Destination Path2 :" + (String)destinationPath);
        StringSelection s = new StringSelection((String)destinationPath);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s, null);
        Thread.sleep(5000L);
        robot.keyPress(17);
        robot.keyPress(86);
        Thread.sleep(1000L);
        robot.keyRelease(17);
        robot.keyRelease(86);
        robot.keyPress(18);
        robot.keyPress(83);
        robot.keyRelease(18);
        robot.keyRelease(83);
        robot.keyPress(18);
        robot.keyPress(89);
        robot.keyRelease(18);
        robot.keyRelease(89);
        Thread.sleep(5000L);
        return destinationPath;
    }

    public static List pdfReader(String filepath) throws IOException {
        System.out.println(filepath);
        File file = new File(filepath);
        PDDocument document = Loader.loadPDF((File)file);
        PDFTextStripper pdfStripper = new PDFTextStripper();
        String text = pdfStripper.getText(document);
        pdfData = new ArrayList<String>(Arrays.asList(text.split("\n")));
        document.close();
        return pdfData;
    }

    private static boolean verifyTextInPDF(List<String> list, String text) {
        for (String pdfText : list) {
            if (!pdfText.toLowerCase().contains(((String)text).toLowerCase())) continue;
            int index = pdfData.indexOf(pdfText);
            String oldString = pdfData.get(index);
            pdfData.remove(index);
            text = (String)text + " ";
            oldString = oldString.replace((CharSequence)text, "");
            pdfData.add(index, oldString);
            return true;
        }
        return false;
    }

    public static boolean verifyTextInPDF(String text) {
        text = text.replaceAll("\"", "").trim();
        text = text.replaceAll("\"", "").trim();
        System.out.println("Text : " + text + "***********");
        System.out.println("pdfData: " + pdfData);
        return BasePage.verifyTextInPDF(new ArrayList<String>(pdfData), text);
    }

    public static String pdfReaderGetString(String filepath) throws IOException {
        System.out.println(filepath);
        File file = new File(filepath);
        PDDocument document = Loader.loadPDF((File)file);
        PDFTextStripper pdfStripper = new PDFTextStripper();
        return pdfStripper.getText(document);
    }

    public void smartVerifyReportsData(List<String> ReportValues) throws Exception {
        String reportFilePath = this.BasePageDestinationPath;
        try {
            BasePage.pdfReader(reportFilePath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int size = ReportValues.size();
        boolean value = false;
        for (String reportValue : ReportValues) {
            if (Collections.frequency(Collections.singleton(reportValue), "\"") > 2) {
                reportValue = reportValue.replaceAll("\"", "");
            }
            if (reportValue.contains(",")) {
                ArrayList<String> values = new ArrayList<String>(List.of(reportValue.split(",")));
                for (String data : values) {
                    value = BasePage.verifyTextInPDF(data);
                    if (value) continue;
                    String newData = data.replaceAll("\\r|\\n", "").replaceAll(" ", "");
                    String pdfData = BasePage.pdfReaderGetString(this.BasePageDestinationPath).replaceAll("\\r|\\n", "").replaceAll(" ", "");
                    if (pdfData.contains(newData)) {
                        try {
                            String[] newArr = reportValue.split("\\r|\\n");
                            BasePage.verifyTextInPDF(newArr[0]);
                            BasePage.verifyTextInPDF(newArr[1]);
                        }
                        catch (Exception ers) {
                            try {
                                String[] newArr = reportValue.split("\\r|\\n| ");
                                BasePage.verifyTextInPDF(newArr[0]);
                                BasePage.verifyTextInPDF(newArr[1]);
                            }
                            catch (Exception exception) {}
                        }
                        continue;
                    }
                    Assert.fail((String)(data + " ,Value is not present in the report."));
                }
                if (!value) continue;
            }
            value = BasePage.verifyTextInPDF(reportValue);
            if (value) continue;
            String newData = reportValue.replaceAll("\\r|\\n", "").replaceAll(" ", "");
            String pdfData = BasePage.pdfReaderGetString(this.BasePageDestinationPath).replaceAll("\\r|\\n", "").replaceAll(" ", "");
            if (pdfData.contains(newData)) {
                try {
                    String[] newArr = reportValue.split("\\r|\\n");
                    BasePage.verifyTextInPDF(newArr[0]);
                    BasePage.verifyTextInPDF(newArr[1]);
                }
                catch (Exception ers) {
                    try {
                        String[] newArr = reportValue.split("\\r|\\n| ");
                        BasePage.verifyTextInPDF(newArr[0]);
                        BasePage.verifyTextInPDF(newArr[1]);
                    }
                    catch (Exception exception) {}
                }
                continue;
            }
            Assert.fail((String)(reportValue + " Value is not present in the report."));
        }
    }

    public String pageGetWebElementForScroll(Element jsonElement, String valueToSet) {
        List<String> locator = List.of("Xpaths");
        String locator1 = null;
        for (String by : locator) {
            String element = this.findStringXpathForScroll(by, jsonElement, valueToSet);
            if (element == null) continue;
            locator1 = element;
            break;
        }
        return locator1;
    }

    public String findStringXpathForScroll(String locator, Element jsonElement, String valueToSet) {
        String selector = "";
        if (jsonElement != null) {
            switch (locator) {
                case "Xpaths": {
                    String xpath;
                    String[] stringArray = jsonElement.getXpaths();
                    int n = stringArray.length;
                    int n2 = 0;
                    if (n2 >= n || (xpath = stringArray[n2]) == null) break;
                    selector = this.getSelector(xpath, valueToSet);
                    break;
                }
            }
        } else {
            System.out.println("The JSON file does not contain information of the passed element");
        }
        return selector;
    }

    public void selectOptionFromDropDownUsingScroll(String dropdownElement, String OptionXPathElement, String optionToClickXPathElement, String optionToClick, String currentPageName) throws InterruptedException {
        Element elementDetails1 = this.getElementDetailsFromPage(dropdownElement, currentPageName);
        ElementHandle Elem1 = this.getWebElement(elementDetails1, "");
        if (Elem1.isEditable()) {
            Elem1.click();
        }
        Element elementDetails2 = this.getElementDetailsFromPage(optionToClickXPathElement, currentPageName);
        ElementHandle Elem2 = this.getWebElement(elementDetails2, optionToClick);
        Element elementDetails3 = this.getElementDetailsFromPage(OptionXPathElement, currentPageName);
        String xpathForOption = this.pageGetWebElementForScroll(elementDetails3, "");
        boolean flag = false;
        int j = 0;
        Thread.sleep(1000L);
        List elements = page.querySelectorAll(xpathForOption);
        do {
            for (int i = 0; i < elements.size(); ++i) {
                System.out.println("Options :" + ((ElementHandle)elements.get(i)).innerText());
                j = i;
                if (!((ElementHandle)elements.get(i)).innerText().equals(optionToClick)) continue;
                ((ElementHandle)elements.get(i)).scrollIntoViewIfNeeded();
                Elem2.click();
                flag = true;
                break;
            }
            if (flag) continue;
            ((ElementHandle)elements.get(j)).scrollIntoViewIfNeeded();
            elements = page.querySelectorAll(xpathForOption);
        } while (!flag);
    }

    public void highlightElement(String elementName, String currentPageName, String valueToSet, String color) {
        if (page == null) {
            System.out.println("Browser Page is null here");
        }
        logger.info(this.getClass().getSimpleName() + "-" + currentPageName + "-" + elementName + "-" + valueToSet);
        Element elementDetails = this.getElementDetailsFromPage(elementName, currentPageName);
        ElementHandle Elem = this.getWebElement(elementDetails, valueToSet);
        logger.info(this.getClass().getSimpleName() + "-" + elementDetails);
        page.evaluate("element => element.style.border='3px solid " + color + "'", (Object)Elem);
    }

    public static byte[] takeDesktopScreenshotBase64() throws Exception {
        Robot robot = new Robot();
        Rectangle screenRect = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        BufferedImage screenCapture = robot.createScreenCapture(screenRect);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)screenCapture, "png", baos);
        baos.flush();
        byte[] imageInBytes = baos.toByteArray();
        baos.close();
        return imageInBytes;
    }

    static {
        count = 0;
        pdfData = new ArrayList<String>();
    }
}

