/*
 * Decompiled with CFR 0.152.
 */
package org.SpurQLabs.Utilities;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.Playwright;
import java.util.logging.Logger;
import org.SpurQLabs.Utilities.CommonUtil;

public class WebUtil {
    protected static Browser browser;
    protected static BrowserContext context;
    protected static Page page;
    private static final Logger LOGGER;

    public static Page webInit() {
        try {
            LOGGER.info("Logging initialized");
            String downloadPath = CommonUtil.getFrameworkConfig("DownloadFolderPath");
            LOGGER.info("Entering application-" + new Object(){}.getClass().getEnclosingMethod().getName());
            String BrowserName = CommonUtil.getFrameworkConfig("ExecutionBrowser");
            Playwright playwright = Playwright.create();
            switch (BrowserName.toLowerCase()) {
                case "chrome": {
                    browser = playwright.chromium().launch(new BrowserType.LaunchOptions().setChannel("chrome").setHeadless(false));
                    break;
                }
                case "firefox": {
                    browser = playwright.firefox().launch(new BrowserType.LaunchOptions().setHeadless(false));
                    break;
                }
                case "edge": {
                    browser = playwright.chromium().launch(new BrowserType.LaunchOptions().setChannel("msedge").setHeadless(false));
                    break;
                }
                case "webkit": {
                    browser = playwright.webkit().launch(new BrowserType.LaunchOptions().setHeadless(false));
                    break;
                }
                case "chromium": {
                    browser = playwright.chromium().launch(new BrowserType.LaunchOptions().setHeadless(false));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported browser type: " + BrowserName);
                }
            }
            context = browser.newContext(new Browser.NewContextOptions());
            Browser.NewPageOptions options = new Browser.NewPageOptions();
            options.setViewportSize(null);
            page = context.newPage();
            LOGGER.info("Running Test Case On Browser: " + BrowserName);
            return page;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void webTearDown() {
        if (browser != null) {
            browser.close();
            context.close();
            page.close();
        }
    }

    static {
        LOGGER = Logger.getLogger(String.valueOf(WebUtil.class));
    }
}

