/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen.loader;

import io.gorules.zen.loader.DecisionLoader;
import io.gorules.zen_engine.JsonBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class MemoryDecisionLoader
implements DecisionLoader {
    private final ConcurrentHashMap<String, JsonBuffer> decisions = new ConcurrentHashMap();

    @Override
    public CompletableFuture<JsonBuffer> load(String key) {
        return CompletableFuture.supplyAsync(() -> {
            JsonBuffer buffer = this.decisions.get(key);
            if (buffer == null) {
                throw new RuntimeException("Decision not found in memory: " + key);
            }
            return buffer;
        });
    }

    public void addDecision(String key, String content) {
        this.decisions.put(key, new JsonBuffer(content.getBytes()));
    }

    public void addDecision(String key, byte[] content) {
        this.decisions.put(key, new JsonBuffer(content));
    }

    public void addDecision(String key, JsonBuffer buffer) {
        this.decisions.put(key, buffer);
    }

    public boolean removeDecision(String key) {
        return this.decisions.remove(key) != null;
    }

    public void clear() {
        this.decisions.clear();
    }

    public boolean contains(String key) {
        return this.decisions.containsKey(key);
    }
}

