/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.util;

import io.jbock.util.Left;
import io.jbock.util.LeftOptional;
import io.jbock.util.Right;
import io.jbock.util.ValidatingCollector;
import io.jbock.util.ValidatingCollectorAll;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;

public abstract class Either<L, R> {
    Either() {
    }

    public static <L, R> Either<L, R> left(L value) {
        return Left.create(value);
    }

    public static <L, R> Either<L, R> right(R value) {
        return Right.create(value);
    }

    public static <L, R> Collector<Either<L, R>, ?, Either<L, List<R>>> toValidList() {
        return new ValidatingCollector();
    }

    public static <L, R> Collector<Either<L, R>, ?, Either<List<L>, List<R>>> toValidListAll() {
        return new ValidatingCollectorAll();
    }

    public final <R2> Either<L, R2> map(Function<? super R, ? extends R2> mapper) {
        return this.fold(Either::left, r -> Either.right(mapper.apply((Object)r)));
    }

    public final <R2> Either<L, R2> flatMap(Function<? super R, ? extends Either<? extends L, ? extends R2>> mapper) {
        return this.fold(Either::left, r -> Either.narrow((Either)mapper.apply((Object)r)));
    }

    public final Either<L, R> filter(Function<? super R, LeftOptional<? extends L>> predicate) {
        return this.fold(Either::left, r -> Either.narrow(((LeftOptional)predicate.apply((Object)r)).orElseRight(() -> r)));
    }

    public final <L2> Either<L2, R> mapLeft(Function<? super L, ? extends L2> mapper) {
        return this.fold(l -> Either.left(mapper.apply((Object)l)), Either::right);
    }

    public final <L2> Either<L2, R> flatMapLeft(Function<? super L, ? extends Either<? extends L2, ? extends R>> mapper) {
        return this.fold(l -> Either.narrow((Either)mapper.apply((Object)l)), Either::right);
    }

    public abstract <X extends Throwable> R orElseThrow(Function<? super L, ? extends X> var1) throws X;

    public abstract <U> U fold(Function<? super L, ? extends U> var1, Function<? super R, ? extends U> var2);

    public final void accept(Consumer<? super L> leftAction, Consumer<? super R> rightAction) {
        this.fold(l -> {
            leftAction.accept((Object)l);
            return null;
        }, r -> {
            rightAction.accept((Object)r);
            return null;
        });
    }

    public final void acceptLeft(Consumer<? super L> leftAction) {
        this.accept(leftAction, r -> {});
    }

    public final void acceptRight(Consumer<? super R> rightAction) {
        this.accept(l -> {}, rightAction);
    }

    public abstract boolean isLeft();

    public final boolean isRight() {
        return !this.isLeft();
    }

    public abstract LeftOptional<L> getLeft();

    public abstract Optional<R> getRight();

    static <L, R> Either<L, R> narrow(Either<? extends L, ? extends R> either) {
        return either;
    }

    public abstract String toString();
}

