/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.util;

import io.jbock.util.Either;
import io.jbock.util.LeftOptional;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

final class Right<L, R>
extends Either<L, R> {
    private final R value;

    private Right(R value) {
        this.value = Objects.requireNonNull(value);
    }

    static <L, R> Right<L, R> create(R value) {
        return new Right<L, R>(value);
    }

    @Override
    public LeftOptional<L> getLeft() {
        return LeftOptional.empty();
    }

    @Override
    public boolean isLeft() {
        return false;
    }

    @Override
    public Optional<R> getRight() {
        return Optional.of(this.value);
    }

    @Override
    public <X extends Throwable> R orElseThrow(Function<? super L, ? extends X> f) throws X {
        return this.value;
    }

    @Override
    public <U> U fold(Function<? super L, ? extends U> leftMapper, Function<? super R, ? extends U> rightMapper) {
        return rightMapper.apply(this.value);
    }

    @Override
    public String toString() {
        return String.format("Right[%s]", this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Right)) {
            return false;
        }
        Right other = (Right)obj;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

