/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.util;

import io.jbock.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

final class ValidatingCollectorAll<L, R>
implements Collector<Either<L, R>, Acc<L, R>, Either<List<L>, List<R>>> {
    ValidatingCollectorAll() {
    }

    @Override
    public Supplier<Acc<L, R>> supplier() {
        return Acc::new;
    }

    @Override
    public BiConsumer<Acc<L, R>, Either<L, R>> accumulator() {
        return Acc::accumulate;
    }

    @Override
    public BinaryOperator<Acc<L, R>> combiner() {
        return Acc::combine;
    }

    @Override
    public Function<Acc<L, R>, Either<List<L>, List<R>>> finisher() {
        return Acc::finish;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Set.of();
    }

    static final class Acc<L, R> {
        private final List<L> left = new ArrayList<L>();
        private final List<R> right = new ArrayList<R>();

        Acc() {
        }

        void accumulate(Either<L, R> either) {
            if (!this.left.isEmpty()) {
                either.acceptLeft(this.left::add);
            } else {
                either.accept(this.left::add, this.right::add);
            }
        }

        Acc<L, R> combine(Acc<L, R> other) {
            if (!this.left.isEmpty()) {
                this.left.addAll(other.left);
                return this;
            }
            if (!other.left.isEmpty()) {
                return other;
            }
            this.right.addAll(other.right);
            return this;
        }

        Either<List<L>, List<R>> finish() {
            if (!this.left.isEmpty()) {
                return Either.left(this.left);
            }
            return Either.right(this.right);
        }
    }
}

