/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.executor;

import io.github.jidcoo.opto.lcdb.enhancer.base.EnhancerException;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class LeetcodeExecutor {
    private final Object instance;
    private final Method executor;
    private Method invoker;
    private Class invokerResponseType;

    LeetcodeExecutor(Object instance, Method executor) {
        this.instance = instance;
        this.executor = executor;
        this.invoker = executor;
    }

    Object execute(Object input) {
        AssertUtil.nonNull(this.invoker, "The leetcode execute invoker cannot be null.");
        try {
            this.invoker.setAccessible(true);
            return this.invoker.invoke(this.instance, (Object[])input);
        }
        catch (InvocationTargetException exception) {
            throw new EnhancerException(exception.getCause());
        }
        catch (Throwable exception) {
            throw new RuntimeException(exception);
        }
    }

    Object getInstance() {
        return this.instance;
    }

    Method getExecutor() {
        return this.executor;
    }

    Method getInvoker() {
        return this.invoker;
    }
}

