/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.parser;

import io.github.jidcoo.opto.lcdb.enhancer.core.parser.InputParserContext;
import io.github.jidcoo.opto.lcdb.enhancer.core.parser.InputParserNode;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ContainerCheckUtil;
import java.util.List;

class InputParserChain
extends InputParserNode {
    private final List<InputParserNode> nodes;

    InputParserChain(List<InputParserNode> nodes) {
        AssertUtil.isTrue(!ContainerCheckUtil.isListEmpty(nodes), "The InputParserNode list cannot be empty.");
        this.nodes = nodes;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    final Object parse(InputParserContext context) {
        for (InputParserNode node : this.nodes) {
            AssertUtil.isTrue(context.getInputStackSize() > 0, "Error no input in context: " + context + ", node: " + node);
            Object curNodeOutput = node.parse(context);
            context.pushInput(curNodeOutput);
        }
        AssertUtil.isTrue(context.getInputStackSize() > 0, "Error no output in context: " + context);
        return context.peekInput();
    }
}

