/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.parser.builtin;

import io.github.jidcoo.opto.lcdb.enhancer.base.BaseParameterAcceptStrategy;
import io.github.jidcoo.opto.lcdb.enhancer.base.struct.TreeNode;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;

@Resource
public final class BinaryTreeParameterAcceptStrategy
extends BaseParameterAcceptStrategy<TreeNode> {
    @Override
    protected TreeNode acceptParameter(Object object, Class type, Map<Class<?>, Set<BaseParameterAcceptStrategy<?>>> strategiesMap) throws Throwable {
        AssertUtil.nonNull(object, "The object cannot be null.");
        AssertUtil.isTrue(object instanceof List, "The object is not a List.");
        List originIntegerList = (List)object;
        if (originIntegerList.isEmpty()) {
            return null;
        }
        Function<Integer, TreeNode> treeNodeCreator = val -> {
            if (Objects.isNull(val)) {
                return null;
            }
            return new TreeNode((int)val);
        };
        List treeNodeList = originIntegerList.stream().map(val -> (TreeNode)treeNodeCreator.apply((Integer)val)).collect(Collectors.toList());
        ArrayDeque<Object> nodeQueue = new ArrayDeque<Object>();
        int treeNodeIdx = 0;
        int treeNodeSize = treeNodeList.size();
        Function<Integer, TreeNode> treeNodeGetter = idx -> {
            if (idx < treeNodeSize) {
                return (TreeNode)treeNodeList.get((int)idx);
            }
            return null;
        };
        nodeQueue.offer(treeNodeList.get(treeNodeIdx++));
        while (!nodeQueue.isEmpty() && treeNodeIdx < treeNodeSize) {
            int nodeQueueSize = nodeQueue.size();
            while (nodeQueueSize > 0 && treeNodeIdx < treeNodeSize) {
                TreeNode curRootNode = (TreeNode)nodeQueue.poll();
                --nodeQueueSize;
                curRootNode.left = treeNodeGetter.apply(treeNodeIdx++);
                curRootNode.right = treeNodeGetter.apply(treeNodeIdx++);
                if (Objects.nonNull(curRootNode.left)) {
                    nodeQueue.offer(curRootNode.left);
                }
                if (!Objects.nonNull(curRootNode.right)) continue;
                nodeQueue.offer(curRootNode.right);
            }
        }
        return (TreeNode)treeNodeList.get(0);
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public Class<? extends TreeNode> getAcceptableType() {
        return TreeNode.class;
    }
}

