/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.parser.builtin;

import io.github.jidcoo.opto.lcdb.enhancer.base.BaseParameterAcceptStrategy;
import io.github.jidcoo.opto.lcdb.enhancer.base.struct.ListNode;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;

@Resource
public final class SinglyLinkedListParameterAcceptStrategy
extends BaseParameterAcceptStrategy<ListNode> {
    @Override
    protected ListNode acceptParameter(Object object, Class type, Map<Class<?>, Set<BaseParameterAcceptStrategy<?>>> strategiesMap) throws Throwable {
        AssertUtil.nonNull(object, "The object cannot be null.");
        AssertUtil.isTrue(object instanceof List, "The object is not a List.");
        List originIntegerList = (List)object;
        ListNode header = null;
        ListNode last = null;
        for (int i = 0; i < originIntegerList.size(); ++i) {
            Integer val = (Integer)originIntegerList.get(i);
            ListNode node = new ListNode(val);
            if (header == null) {
                header = node;
            }
            if (last != null) {
                last.next = node;
            }
            last = node;
        }
        return header;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public Class<? extends ListNode> getAcceptableType() {
        return ListNode.class;
    }
}

