/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.printer;

import io.github.jidcoo.opto.lcdb.enhancer.base.BasePrintingStrategy;
import io.github.jidcoo.opto.lcdb.enhancer.base.Order;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.GsonUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.lang.model.type.NullType;

final class OutputPrinter
extends BasePrintingStrategy<Object> {
    private final Map<Class<?>, Set<BasePrintingStrategy<?>>> printingStrategyMap = new HashMap();

    OutputPrinter(List<BasePrintingStrategy> printingStrategyList) {
        printingStrategyList.add(this);
        printingStrategyList = printingStrategyList.stream().filter(Objects::nonNull).collect(Collectors.toList());
        Comparator<Order> printingStrategyComparator = Comparator.comparingInt(Order::getOrder).reversed();
        BiConsumer<Class, BasePrintingStrategy> mapBuilder = (clazz, printingStrategy) -> {
            AssertUtil.nonNull(clazz, "The accepted type of the " + printingStrategy + " cannot be null.");
            Set strategySet = this.printingStrategyMap.computeIfAbsent((Class<?>)clazz, key -> new TreeSet(printingStrategyComparator));
            strategySet.add(printingStrategy);
        };
        for (BasePrintingStrategy<Object> printingStrategy2 : printingStrategyList) {
            mapBuilder.accept(printingStrategy2.getAcceptableType(), printingStrategy2);
        }
        Arrays.asList(Object.class, NullType.class, Void.class).forEach(type -> mapBuilder.accept((Class)type, this));
    }

    String print(Object output, Class outputType) {
        Set strategySet = this.findStrategySet(Objects.nonNull(outputType) ? outputType : output, this.printingStrategyMap);
        Throwable lastThrowable = null;
        for (BasePrintingStrategy printingStrategy : strategySet) {
            try {
                return printingStrategy.accept((Class)null, output, (Map)this.printingStrategyMap);
            }
            catch (Throwable e) {
                lastThrowable = e;
            }
        }
        throw new RuntimeException("Cannot print output :" + output, lastThrowable);
    }

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Override
    public Class<?> getAcceptableType() {
        return Object.class;
    }

    @Override
    protected String printOutput(Object outputObject, Map<Class<?>, Set<BasePrintingStrategy<?>>> strategiesMap) {
        return GsonUtil.toJson(outputObject);
    }
}

