/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.utils;

import java.io.PrintStream;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnhancerLogUtil {
    private static void log(Level level, String msg) {
        if (Logger.getGlobal().isLoggable(level)) {
            PrintStream printStream = System.out;
            if (Level.SEVERE.equals(level)) {
                printStream = System.err;
            }
            printStream.println("[" + level + "] " + msg);
            printStream.flush();
        }
    }

    public static void logE(String format, Object ... args) {
        EnhancerLogUtil.log(Level.SEVERE, String.format(format, args));
    }

    public static void logI(String format, Object ... args) {
        EnhancerLogUtil.log(Level.INFO, String.format(format, args));
    }

    public static void logW(String format, Object ... args) {
        EnhancerLogUtil.log(Level.WARNING, String.format(format, args));
    }

    public static void setLogLevel(Level level) {
        if (Objects.nonNull(level) && level.intValue() >= Level.INFO.intValue()) {
            Logger.getGlobal().setLevel(level);
        }
    }
}

