/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.utils;

import io.github.jidcoo.opto.lcdb.enhancer.LeetcodeJavaDebugEnhancer;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;

public class ReflectUtil {
    public static <T> T createInstance(Class<T> clazz) {
        AssertUtil.nonNull(clazz, "The class cannot be null.");
        try {
            Constructor<T> declaredConstructor = clazz.getDeclaredConstructor(new Class[0]);
            declaredConstructor.setAccessible(true);
            return declaredConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object resolveSolutionInstance(Object object) {
        Class<?>[] declaredClasses;
        AssertUtil.nonNull(object, "The object cannot be null.");
        AssertUtil.isTrue(object instanceof LeetcodeJavaDebugEnhancer, "The object is not an inherited object from LeetcodeJavaDebugEnhancer");
        Class<?> __AT__class = object.getClass();
        for (Class<?> declaredClass : declaredClasses = __AT__class.getDeclaredClasses()) {
            if (!"Solution".equals(declaredClass.getSimpleName())) continue;
            try {
                Constructor<?> declaredConstructor = declaredClass.getDeclaredConstructor(__AT__class);
                declaredConstructor.setAccessible(true);
                return declaredConstructor.newInstance(object);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("No inner class Solution found in class: " + object.getClass());
    }

    public static boolean isImplementInterface(Class<?> clazz, Class<?> interfaceClass) {
        AssertUtil.nonNull(clazz, "The class cannot be null.");
        AssertUtil.nonNull(interfaceClass, "The interface cannot be null.");
        return Arrays.stream(clazz.getInterfaces()).anyMatch(clz -> interfaceClass == clz);
    }

    public static boolean isExtendsClass(Class<?> clazz, Class<?> superClass) {
        AssertUtil.nonNull(clazz, "The class cannot be null.");
        AssertUtil.nonNull(superClass, "The super class cannot be null.");
        return superClass.isAssignableFrom(clazz);
    }

    public static Field getField(String fieldName, Class fieldType, Object obj) {
        AssertUtil.isTrue(!StringUtil.isBlank(fieldName), "The fieldName cannot be blank.");
        AssertUtil.nonNull(fieldType, "The fieldType cannot be null.");
        AssertUtil.nonNull(obj, "The obj cannot be null.");
        try {
            Field declaredField = obj.getClass().getDeclaredField(fieldName);
            AssertUtil.isTrue(Objects.equals(declaredField.getType(), fieldType), "The type of the field " + fieldName + " in object " + obj + " is " + declaredField.getType().getSimpleName() + ", not " + fieldType.getSimpleName() + ".");
            return declaredField;
        }
        catch (Error | Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getFieldValue(String fieldName, Class<? extends T> fieldType, Object obj) {
        Field field = ReflectUtil.getField(fieldName, fieldType, obj);
        try {
            field.setAccessible(true);
            return (T)field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void setFieldValue(String fieldName, Class<? extends T> fieldType, Object value, Object obj) {
        Field field = ReflectUtil.getField(fieldName, fieldType, obj);
        try {
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getMethod(Class<?> target, String methodName, Class<?> ... parameterTypes) {
        AssertUtil.nonNull(target, "The target class cannot be null.");
        AssertUtil.isTrue(!StringUtil.isBlank(methodName), "The method name cannot be blank.");
        try {
            return target.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

