/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.base;

import io.github.jidcoo.opto.lcdb.enhancer.base.Order;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ContainerCheckUtil;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.type.NullType;

public interface Strategizable<AcceptableType, Output, Strategy>
extends Order {
    public Class<? extends AcceptableType> getAcceptableType();

    default public Class<?> getObjectType(Object object) {
        if (Objects.isNull(object)) {
            return NullType.class;
        }
        if (object instanceof Class) {
            return (Class)object;
        }
        return object.getClass();
    }

    default public void checkObjectAcceptable(Object object) {
        Class<AcceptableType> acceptedType = this.getAcceptableType();
        AssertUtil.nonNull(acceptedType, "The acceptable type cannot be null in " + this.getClass().getSimpleName() + ".");
        AssertUtil.isTrue(Objects.equals(acceptedType, this.getObjectType(object)), "The object is not accepted in " + this.getClass().getSimpleName() + ": " + object);
    }

    default public Set<Strategy> findStrategySet(Object object, Map<Class<?>, Set<Strategy>> strategiesMap) {
        Set strategySet = strategiesMap.getOrDefault(this.getObjectType(object), strategiesMap.getOrDefault(Void.class, null));
        AssertUtil.isTrue(!ContainerCheckUtil.isSetEmpty(strategySet), "Cannot find any appropriate accepted strategy set for the object: " + object);
        return strategySet;
    }

    default public Output accept(Class classType, Object object, Map<Class<?>, Set<Strategy>> strategiesMap) throws Throwable {
        throw new RuntimeException("Stub!");
    }
}

