/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core;

import io.github.jidcoo.opto.lcdb.enhancer.LeetcodeJavaDebugEnhancer;
import io.github.jidcoo.opto.lcdb.enhancer.base.InputProvider;
import io.github.jidcoo.opto.lcdb.enhancer.base.OutputConsumer;
import io.github.jidcoo.opto.lcdb.enhancer.core.executor.LeetcodeExecutor;
import io.github.jidcoo.opto.lcdb.enhancer.core.executor.LeetcodeExecutorFactory;
import io.github.jidcoo.opto.lcdb.enhancer.core.executor.LeetcodeExecutorProcessor;
import io.github.jidcoo.opto.lcdb.enhancer.core.io.IOFactory;
import io.github.jidcoo.opto.lcdb.enhancer.core.parser.InputParser;
import io.github.jidcoo.opto.lcdb.enhancer.core.parser.InputParserFactory;
import io.github.jidcoo.opto.lcdb.enhancer.core.parser.InputParserProcessor;
import io.github.jidcoo.opto.lcdb.enhancer.core.printer.OutputPrinter;
import io.github.jidcoo.opto.lcdb.enhancer.core.printer.OutputPrinterFactory;
import io.github.jidcoo.opto.lcdb.enhancer.core.printer.OutputPrinterProcessor;
import io.github.jidcoo.opto.lcdb.enhancer.utils.EnhancerLogUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ReflectUtil;

public class LeetcodeJavaDebugEnhanceProcessor {
    public static void process(Class<? extends LeetcodeJavaDebugEnhancer> AT) throws Exception, Error {
        LeetcodeJavaDebugEnhancer enhancer = ReflectUtil.createInstance(AT);
        EnhancerLogUtil.setLogLevel(enhancer.getEnhancerLogLevel());
        EnhancerLogUtil.logI("Starting do debugging enhance at (AT) class: %s", AT.getSimpleName());
        LeetcodeExecutor leetcodeExecutor = LeetcodeExecutorFactory.getLeetcodeExecutor(enhancer);
        OutputPrinter outputPrinter = OutputPrinterFactory.getOutputPrinter(enhancer);
        InputParser inputParser = InputParserFactory.getInputParser(enhancer);
        try (InputProvider inputProvider = IOFactory.getInputProvider(enhancer);
             OutputConsumer outputConsumer = IOFactory.getOutputConsumer(enhancer);){
            String input;
            EnhancerLogUtil.logI("Running leetcode debugging enhancer at (AT) class: %s", AT.getSimpleName());
            while (!inputProvider.isEnd(input = inputProvider.provideNextInput())) {
                Object inputObject = InputParserProcessor.process(inputParser, leetcodeExecutor, input);
                Object outputObject = LeetcodeExecutorProcessor.process(leetcodeExecutor, inputObject);
                String output = OutputPrinterProcessor.process(outputPrinter, leetcodeExecutor, outputObject);
                outputConsumer.consumeNextOutput(output);
            }
        }
        EnhancerLogUtil.logI("Stopped leetcode debugging enhancer at (AT) class: %s", AT.getSimpleName());
    }
}

