/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.io.builtin;

import io.github.jidcoo.opto.lcdb.enhancer.base.InputProvider;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class BaseBufferReaderInputProvider
implements InputProvider {
    private final BufferedReader bufferedReader;

    public BaseBufferReaderInputProvider(BufferedReader bufferedReader) {
        AssertUtil.nonNull(bufferedReader, "The bufferedReader cannot be null.");
        this.bufferedReader = bufferedReader;
    }

    public BaseBufferReaderInputProvider(InputStream inputStream) {
        AssertUtil.nonNull(inputStream, "The inputStream cannot be null.");
        this.bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
    }

    @Override
    public String provideNextInput() {
        try {
            return this.bufferedReader.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isEnd(String input) {
        return StringUtil.isBlank(input);
    }

    @Override
    public void close() throws Exception {
        this.bufferedReader.close();
    }
}

