/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.parser;

import io.github.jidcoo.opto.lcdb.enhancer.core.parser.InputParserContext;
import io.github.jidcoo.opto.lcdb.enhancer.core.parser.InputParserNode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;

@Resource
final class IRInputParserNode
extends InputParserNode {
    private static final char STRING_END_TOKEN = '\u0000';
    private static final String NULL_TYPE_TOKEN = "null";
    private static final String BOOLEAN_TYPE_TRUE_TOKEN = "true";
    private static final String BOOLEAN_TYPE_FALSE_TOKEN = "false";
    private static final char NUMBER_DOUBLE_TYPE_DOT_TOKEN = '.';
    private static final char NUMBER_POSITIVE_SYMBOL_TOKEN = '+';
    private static final char NUMBER_NEGATIVE_SYMBOL_TOKEN = '-';
    private static final char STRING_BEGIN_TOKEN = '\"';
    private static final char STRING_FINISH_TOKEN = '\"';
    private static final char ARRAY_BEGIN_TOKEN = '[';
    private static final char ARRAY_FINISH_TOKEN = ']';
    private static final char ARRAY_ELEMENTS_SEPARATOR_TOKEN = ',';

    IRInputParserNode() {
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    Object parse(InputParserContext context) {
        String input = (String)context.peekInput();
        int[] parseIndex = new int[1];
        ArrayList<Object> objects = new ArrayList<Object>();
        while (parseIndex[0] < input.length()) {
            Object result = IRInputParserNode.parseInput(parseIndex, input);
            objects.add(result);
            IRInputParserNode.skipWhiteSpace(parseIndex, input);
            if (IRInputParserNode.peekChar(parseIndex[0], input) != ',') continue;
            IRInputParserNode.consumeChar(parseIndex, input, ',');
            IRInputParserNode.skipWhiteSpace(parseIndex, input);
        }
        return objects;
    }

    private static char peekChar(int index, String input) {
        return index < input.length() ? input.charAt(index) : (char)'\u0000';
    }

    private static void consumeChar(int[] index, String input, char expectedChar) {
        char nextChar = IRInputParserNode.peekChar(index[0], input);
        if (nextChar == expectedChar) {
            index[0] = index[0] + 1;
            return;
        }
        throw new RuntimeException("Unexpected character. Expected '" + expectedChar + "', but found '" + nextChar + "'.");
    }

    private static void skipWhiteSpace(int[] index, String input) {
        while (index[0] < input.length() && Character.isWhitespace(IRInputParserNode.peekChar(index[0], input))) {
            index[0] = index[0] + 1;
        }
    }

    private static boolean parseBooleanType(int[] index, String input) {
        if (input.startsWith(BOOLEAN_TYPE_TRUE_TOKEN, index[0])) {
            index[0] = index[0] + BOOLEAN_TYPE_TRUE_TOKEN.length();
            return true;
        }
        index[0] = index[0] + BOOLEAN_TYPE_FALSE_TOKEN.length();
        return false;
    }

    private static Object parseNumberType(int[] index, String input) {
        char nextChar;
        StringBuilder stringBuilder = new StringBuilder();
        boolean isDoubleType = false;
        while (index[0] < input.length() && (Character.isDigit(nextChar = IRInputParserNode.peekChar(index[0], input)) || nextChar == '.' || nextChar == '+' || nextChar == '-')) {
            stringBuilder.append(nextChar);
            index[0] = index[0] + 1;
            if (nextChar != '.') continue;
            isDoubleType = true;
        }
        String numberString = stringBuilder.toString();
        if (isDoubleType) {
            return Double.parseDouble(numberString);
        }
        try {
            return Integer.parseInt(numberString);
        }
        catch (NumberFormatException numberFormatException) {
            return Long.parseLong(numberString);
        }
    }

    private static String parseStringType(int[] index, String input) {
        char nextChar;
        IRInputParserNode.consumeChar(index, input, '\"');
        StringBuilder stringBuilder = new StringBuilder();
        while ((nextChar = IRInputParserNode.peekChar(index[0], input)) != '\"') {
            stringBuilder.append(nextChar);
            index[0] = index[0] + 1;
        }
        IRInputParserNode.consumeChar(index, input, '\"');
        return stringBuilder.toString();
    }

    private static List<Object> parseArrayType(int[] index, String input) {
        IRInputParserNode.consumeChar(index, input, '[');
        ArrayList<Object> array = new ArrayList<Object>();
        IRInputParserNode.skipWhiteSpace(index, input);
        while (IRInputParserNode.peekChar(index[0], input) != ']') {
            array.add(IRInputParserNode.parseInput(index, input));
            IRInputParserNode.skipWhiteSpace(index, input);
            if (IRInputParserNode.peekChar(index[0], input) != ',') continue;
            IRInputParserNode.consumeChar(index, input, ',');
            IRInputParserNode.skipWhiteSpace(index, input);
        }
        IRInputParserNode.consumeChar(index, input, ']');
        return array;
    }

    private static Object parseInput(int[] index, String input) {
        IRInputParserNode.skipWhiteSpace(index, input);
        char nextChar = IRInputParserNode.peekChar(index[0], input);
        if (nextChar == '[') {
            return IRInputParserNode.parseArrayType(index, input);
        }
        if (nextChar == '\"') {
            return IRInputParserNode.parseStringType(index, input);
        }
        if (Character.isDigit(nextChar) || nextChar == '+' || nextChar == '-') {
            return IRInputParserNode.parseNumberType(index, input);
        }
        if (input.startsWith(BOOLEAN_TYPE_TRUE_TOKEN, index[0]) || input.startsWith(BOOLEAN_TYPE_FALSE_TOKEN, index[0])) {
            return IRInputParserNode.parseBooleanType(index, input);
        }
        if (input.startsWith(NULL_TYPE_TOKEN, index[0])) {
            index[0] = index[0] + NULL_TYPE_TOKEN.length();
            return null;
        }
        throw new RuntimeException("Unexpected character: " + nextChar);
    }
}

