/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.parser;

import io.github.jidcoo.opto.lcdb.enhancer.core.parser.InputParserContext;
import io.github.jidcoo.opto.lcdb.enhancer.core.parser.InputParserNode;
import io.github.jidcoo.opto.lcdb.enhancer.core.parser.ParameterAcceptResult;
import io.github.jidcoo.opto.lcdb.enhancer.core.parser.ParameterAcceptStrategyTracer;
import io.github.jidcoo.opto.lcdb.enhancer.core.parser.ParameterAcceptor;
import io.github.jidcoo.opto.lcdb.enhancer.utils.EnhancerLogUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.GsonUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import javax.annotation.Resource;

@Resource
final class IRMatchInputParserNode
extends InputParserNode {
    private final ParameterAcceptor parameterAcceptor = new ParameterAcceptor();

    IRMatchInputParserNode() {
    }

    @Override
    public int getOrder() {
        return 0x7FFFFFFE;
    }

    @Override
    Object parse(InputParserContext context) {
        Method bossInvoker = null;
        ArrayList bossInput = new ArrayList();
        List input = (List)context.peekInput();
        Method[] leetcodeInvokers = this.fetchLeetcodeInvokers(context, input.size());
        HashMap<Method, Map<Integer, Stack<ParameterAcceptStrategyTracer>>> matchTracer = new HashMap<Method, Map<Integer, Stack<ParameterAcceptStrategyTracer>>>();
        if (Objects.nonNull(leetcodeInvokers) && leetcodeInvokers.length > 0) {
            for (Method leetcodeInvoker : leetcodeInvokers) {
                if (leetcodeInvoker.isDefault() || leetcodeInvoker.getParameterCount() != input.size()) continue;
                HashMap<Integer, Stack<ParameterAcceptStrategyTracer>> invokerMatchTracerMap = new HashMap<Integer, Stack<ParameterAcceptStrategyTracer>>();
                ArrayList<Object> acceptedInput = new ArrayList<Object>();
                Class<?>[] parameterTypes = leetcodeInvoker.getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> parameterType = parameterTypes[i];
                    Object copiedObject = this.deepCopy(input.get(i));
                    ParameterAcceptResult result = this.parameterAcceptor.accept(parameterType, copiedObject);
                    if (!result.isAccepted()) {
                        invokerMatchTracerMap.put(i, result.getTracer());
                        break;
                    }
                    acceptedInput.add(result.getObject());
                }
                if (!invokerMatchTracerMap.isEmpty()) {
                    matchTracer.put(leetcodeInvoker, invokerMatchTracerMap);
                }
                if (leetcodeInvoker.getParameterCount() != acceptedInput.size()) continue;
                bossInvoker = leetcodeInvoker;
                bossInput = acceptedInput;
                break;
            }
        }
        this.logDetailAfterIRMatching(bossInvoker, leetcodeInvokers, input, matchTracer);
        context.setTargetMethod(bossInvoker);
        return bossInput.stream().toArray(Object[]::new);
    }

    private void logDetailAfterIRMatching(Method bossInvoker, Method[] invokers, List<Object> input, Map<Method, Map<Integer, Stack<ParameterAcceptStrategyTracer>>> matchTracer) {
        if (Objects.isNull(bossInvoker)) {
            if (invokers.length == 0) {
                throw new RuntimeException("Cannot find any possible leetcode invoker.");
            }
            StringBuilder logBuffer = new StringBuilder();
            logBuffer.append("[IR-Matching Tracer Error Report Detail Start]\n");
            logBuffer.append("LeetcodeInvokers: " + invokers.length + ",  IRInputs: " + input.size());
            logBuffer.append("\n<TracersDetail>\n");
            int invokerIdx = 0;
            for (Map.Entry<Method, Map<Integer, Stack<ParameterAcceptStrategyTracer>>> methodListEntry : matchTracer.entrySet()) {
                logBuffer.append("LeetcodeInvoker-" + invokerIdx++);
                logBuffer.append(": ");
                logBuffer.append(methodListEntry.getKey().toGenericString());
                logBuffer.append("\n<Tracers(" + methodListEntry.getValue().size() + ")>\n");
                Map<Integer, Stack<ParameterAcceptStrategyTracer>> stackMap = methodListEntry.getValue();
                for (Map.Entry<Integer, Stack<ParameterAcceptStrategyTracer>> stackEntry : stackMap.entrySet()) {
                    logBuffer.append(" - Index: " + stackEntry.getKey());
                    logBuffer.append(",   Parameter: " + methodListEntry.getKey().getParameters()[stackEntry.getKey()].getName());
                    logBuffer.append(",   Type: " + methodListEntry.getKey().getParameters()[stackEntry.getKey()].getParameterizedType().getTypeName());
                    logBuffer.append(",   Input(" + (input.get(stackEntry.getKey()) == null ? "Null" : input.get(stackEntry.getKey()).getClass().getSimpleName()) + "): " + GsonUtil.toJson(input.get(stackEntry.getKey())));
                    logBuffer.append("\n");
                    Stack<ParameterAcceptStrategyTracer> tracerStack = stackEntry.getValue();
                    while (!tracerStack.empty()) {
                        ParameterAcceptStrategyTracer tracer = tracerStack.pop();
                        logBuffer.append(tracer.toString());
                    }
                }
                if (invokerIdx >= invokers.length) continue;
                logBuffer.append("\n");
            }
            logBuffer.append("[IR-Matching Tracer Error Report Detail END]\n");
            EnhancerLogUtil.logE("Cannot match any leetcode invoker for IR-Input: %s\n\n%s", input, logBuffer.toString());
            throw new RuntimeException("Cannot match any leetcode invoker for IR-Input.");
        }
    }

    private Object deepCopy(Object object) {
        if (Objects.isNull(object)) {
            return null;
        }
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        ByteArrayInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            bis = new ByteArrayInputStream(bos.toByteArray());
            ois = new ObjectInputStream(bis);
            Object object2 = ois.readObject();
            return object2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Method[] fetchLeetcodeInvokers(InputParserContext context, int invokerParameterSize) {
        if (Objects.nonNull(context.getTargetMethod())) {
            return new Method[]{context.getTargetMethod()};
        }
        return (Method[])Arrays.stream(context.getTargetInstance().getClass().getDeclaredMethods()).filter(m -> Modifier.isPublic(m.getModifiers())).filter(m -> m.getParameterCount() == invokerParameterSize).toArray(Method[]::new);
    }
}

