/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.parser;

import java.lang.reflect.Method;
import java.util.Stack;

final class InputParserContext {
    private final Object targetInstance;
    private final Stack<Object> inputStack;
    private Method targetMethod;

    InputParserContext(Object targetInstance, String input, Method targetMethod) {
        this.targetInstance = targetInstance;
        this.inputStack = new Stack();
        this.inputStack.push(input);
        this.targetMethod = targetMethod;
    }

    Object getTargetInstance() {
        return this.targetInstance;
    }

    <T> T pushInput(T input) {
        return (T)this.inputStack.push(input);
    }

    Object peekInput() {
        return this.inputStack.peek();
    }

    Object popInput() {
        return this.inputStack.pop();
    }

    int getInputStackSize() {
        return this.inputStack.size();
    }

    Method getTargetMethod() {
        return this.targetMethod;
    }

    void setTargetMethod(Method targetMethod) {
        this.targetMethod = targetMethod;
    }
}

