/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.printer.builtin;

import io.github.jidcoo.opto.lcdb.enhancer.base.BasePrintingStrategy;
import io.github.jidcoo.opto.lcdb.enhancer.base.struct.TreeNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;

@Resource
public final class BinaryTreePrintingStrategy
extends BasePrintingStrategy<TreeNode> {
    @Override
    protected String printOutput(TreeNode treeNode, Map<Class<?>, Set<BasePrintingStrategy<?>>> strategiesMap) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        if (Objects.nonNull(treeNode)) {
            int treeNodeSize;
            ArrayList<Integer> valList = new ArrayList<Integer>();
            LinkedList<TreeNode> treeNodeQueue = new LinkedList<TreeNode>();
            treeNodeQueue.add(treeNode);
            while (!treeNodeQueue.isEmpty()) {
                for (int nodeSize = treeNodeQueue.size(); nodeSize > 0; --nodeSize) {
                    TreeNode curNode = (TreeNode)treeNodeQueue.poll();
                    if (Objects.nonNull(curNode)) {
                        valList.add(curNode.val);
                        treeNodeQueue.offer(curNode.left);
                        treeNodeQueue.offer(curNode.right);
                        continue;
                    }
                    valList.add(null);
                }
            }
            for (treeNodeSize = valList.size() - 1; treeNodeSize >= 0 && !Objects.nonNull(valList.get(treeNodeSize)); --treeNodeSize) {
            }
            ++treeNodeSize;
            for (int i = 0; i < treeNodeSize; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(valList.get(i));
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public Class<? extends TreeNode> getAcceptableType() {
        return TreeNode.class;
    }
}

