/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.utils;

import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ContainerCheckUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.PackageUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BeanUtil {
    public static <T> List<T> collectBeans(Class<? extends T> type, String packageName, Function<Class, Boolean> classFilter, Function<Class<? extends T>, T> beanCreator) {
        AssertUtil.nonNull(type, "The bean type cannot be null.");
        AssertUtil.isTrue(!StringUtil.isBlank(packageName), "The beans package name cannot be blank.");
        AssertUtil.nonNull(classFilter, "The class filter cannot be null.");
        AssertUtil.nonNull(beanCreator, "The bean creator cannot be null.");
        List<Class<?>> classesByPackage = PackageUtil.getClassesByPackage(packageName);
        if (!ContainerCheckUtil.isListEmpty(classesByPackage)) {
            return classesByPackage.stream().filter(klass -> (Boolean)classFilter.apply((Class)klass)).map(klass -> beanCreator.apply((Class)klass)).collect(Collectors.toList());
        }
        return new ArrayList();
    }
}

