/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.io.builtin;

import io.github.jidcoo.opto.lcdb.enhancer.base.OutputConsumer;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.StringUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public abstract class BaseBufferWriterOutputConsumer
implements OutputConsumer {
    private final BufferedWriter bufferedWriter;

    public BaseBufferWriterOutputConsumer(BufferedWriter bufferedWriter) {
        AssertUtil.nonNull(bufferedWriter, "The bufferedWriter cannot be null.");
        this.bufferedWriter = bufferedWriter;
    }

    public BaseBufferWriterOutputConsumer(OutputStream outputStream) {
        AssertUtil.nonNull(outputStream, "The outputStream cannot be null.");
        this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    @Override
    public void consumeNextOutput(String output) {
        if (!StringUtil.isEmpty(output)) {
            try {
                this.bufferedWriter.write(output);
                this.bufferedWriter.write(10);
                this.bufferedWriter.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.bufferedWriter.close();
    }
}

