/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.parser;

import io.github.jidcoo.opto.lcdb.enhancer.base.Order;
import io.github.jidcoo.opto.lcdb.enhancer.base.Require;
import io.github.jidcoo.opto.lcdb.enhancer.core.parser.InputParseTask;
import io.github.jidcoo.opto.lcdb.enhancer.core.parser.InputParserChain;
import io.github.jidcoo.opto.lcdb.enhancer.core.parser.InputParserContext;
import io.github.jidcoo.opto.lcdb.enhancer.core.parser.InputParserNode;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ContainerCheckUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.PackageUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ReflectUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

final class InputParser {
    private static final String INPUT_PARSER_NODE_PACKAGE = "io.github.jidcoo.opto.lcdb.enhancer.core.parser";
    private InputParserChain parserChain;

    InputParser() {
        ArrayList<InputParserNode> inputParserNodes = new ArrayList<InputParserNode>();
        List<Class<?>> classesByPackage = PackageUtil.getClassesByPackage(INPUT_PARSER_NODE_PACKAGE);
        if (!ContainerCheckUtil.isListEmpty(classesByPackage)) {
            for (Class<?> clazz : classesByPackage) {
                if (!ReflectUtil.isExtendsClass(clazz, InputParserNode.class) || !clazz.isAnnotationPresent(Require.class)) continue;
                InputParserNode inputParserNode = (InputParserNode)ReflectUtil.createInstance(clazz);
                inputParserNodes.add(inputParserNode);
            }
        }
        inputParserNodes.sort(Comparator.comparingInt(Order::getOrder).reversed());
        this.parserChain = new InputParserChain(inputParserNodes);
    }

    Object parse(InputParseTask inputParseTask) {
        InputParserContext inputParserContext = this.createParserContext(inputParseTask);
        Object inputObject = this.parserChain.parse(inputParserContext);
        inputParseTask.setTargetInvoker(inputParserContext.getTargetInvoker());
        return inputObject;
    }

    private InputParserContext createParserContext(InputParseTask inputParseTask) {
        AssertUtil.nonNull(inputParseTask, "The inputParseTask cannot be null");
        AssertUtil.nonNull(inputParseTask.getTargetInstance(), "The target cannot be null");
        AssertUtil.nonNull(inputParseTask.getInput(), "The input cannot be null");
        return new InputParserContext(inputParseTask.getTargetInstance(), inputParseTask.getInput(), inputParseTask.getCandidateInvokers());
    }
}

